/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.lang.reflect.InvocationTargetException;

import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.service.journal.JournalEditor;
import jp.ossc.nimbus.service.journal.EditorFinder;

/**
 * Throwable𕶎ɕҏWJournalEditorT[rXB<p>
 * 
 * @author M.Takata
 */
public class ThrowableJournalEditorService extends ServiceBase
 implements JournalEditor, ThrowableJournalEditorServiceMBean{
    
    private static final long serialVersionUID = -8053469457068019795L;
    
    protected static final String SERVLET_EXCEPTION_NAME = "javax.servlet.ServletException";
    protected static final String GET_ROOT_CAUSE_METHOD = "getRootCause";
    protected static final String JMS_EXCEPTION_NAME = "javax.jms.JMSException";
    protected static final String GET_LINKED_EXCEPTION_METHOD = "getLinkedException";
    protected static final String LINE_SEP = System.getProperty("line.separator");
    
    protected static final String TAB = "\t";
    protected static final String CONTINUED = "...";
    
    /** (Cause)ǂďo͂邩ǂ */
    protected boolean isOutputCause = true;
    
    /** (Cause)ǂďo͂TAB邩ǂ */
    protected boolean isOutputTab = true;
    
    protected int maxStackTraceSize = -1;
    
    @Override
    public void setOutputCause(boolean isOutput){
        isOutputCause = isOutput;
    }
    
    @Override
    public boolean getOutputCause(){
        return isOutputCause;
    }
    
    @Override
    public boolean getOutputTab(){
        return isOutputTab;
    }
    
    @Override
    public void setOutputTab(boolean isOutput){
        isOutputTab = isOutput;
    }
    
    @Override
    public int getMaxStackTraceSize(){
        return maxStackTraceSize;
    }
    
    @Override
    public void setMaxStackTraceSize(int max){
        maxStackTraceSize = max;
    }
    
    @Override
    public Object toObject(EditorFinder finder, String key, Object value){
        final StringBuilder buf = new StringBuilder();
        Throwable e = (Throwable)value;
        if(e != null){
            buf.append("Exception occuers :").append(e.toString()).append(LINE_SEP);
            final StackTraceElement[] elemss = e.getStackTrace();
            if(elemss != null){
                for(int i = 0; i < elemss.length; i++){
                    if(isOutputTab){
                        buf.append(TAB);
                    }
                    if(maxStackTraceSize >= 0 && i >= maxStackTraceSize){
                        buf.append(CONTINUED).append(LINE_SEP);
                        break;
                    }
                    if(elemss[i] != null){
                        buf.append(elemss[i].toString()).append(LINE_SEP);
                    }else{
                        buf.append("null").append(LINE_SEP);
                    }
                }
            }
            if(isOutputCause){
                for(Throwable ee = getCause(e); ee != null; ee = getCause(ee)){
                    buf.append("Caused by:").append(ee.toString()).append(LINE_SEP);
                    final StackTraceElement[] elems = ee.getStackTrace();
                    if(elems != null){
                        for(int i = 0; i < elems.length; i++){
                            if(isOutputTab){
                                buf.append(TAB);
                            }
                            if(maxStackTraceSize >= 0 && i >= maxStackTraceSize){
                                buf.append(CONTINUED).append(LINE_SEP);
                                break;
                            }
                            if(elems[i] != null){
                                buf.append(elems[i].toString()).append(LINE_SEP);
                            }else{
                                buf.append("null").append(LINE_SEP);
                            }
                        }
                    }
                }
            }
        }else{
            buf.append("Exception occuers :").append(e).append(LINE_SEP);
        }
        return buf.toString();
    }
    
    protected Throwable getCause(Throwable th){
        Throwable cause = null;
        String thClassName = th.getClass().getName();
        if(thClassName.equals(SERVLET_EXCEPTION_NAME)){
            // OServletException̏ꍇ́A[ǧ擾
            try{
                cause = (Throwable)th.getClass()
                    .getMethod(GET_ROOT_CAUSE_METHOD).invoke(th);
            }catch(NoSuchMethodException e){
            }catch(IllegalAccessException e){
            }catch(InvocationTargetException e){
            }
        }else if(thClassName.equals(JMS_EXCEPTION_NAME)){
            // OJMSException̏ꍇ́ANO擾
            try{
                cause = (Exception)th.getClass()
                    .getMethod(GET_LINKED_EXCEPTION_METHOD).invoke(th);
            }catch(NoSuchMethodException e){
            }catch(IllegalAccessException e){
            }catch(InvocationTargetException e){
            }
        }else{
            cause = th.getCause();
        }
        return cause == th ? null : cause;
    }
}