/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.queue;

import jp.ossc.nimbus.core.*;

/**
 * {@link QueueHandlerContainerService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see QueueHandlerContainerService
 */
public interface QueueHandlerContainerServiceMBean extends ServiceBaseMBean{
    
    public static final String DEFAULT_HANDLING_ERROR_MESSAGE_ID = "QHC__00001";
    public static final String DEFAULT_RETRY_OVER_ERROR_MESSAGE_ID = "QHC__00002";
    
    /**
     * nhO{@link Queue}T[rX̃T[rXݒ肷B<p>
     *
     * @param name QueueT[rX̃T[rX
     */
    public void setQueueServiceName(ServiceName name);
    
    /**
     * nhO{@link Queue}T[rX̃T[rX擾B<p>
     *
     * @return QueueT[rX̃T[rX
     */
    public ServiceName getQueueServiceName();
    
    /**
     * {@link QueueHandler}T[rX̃T[rXݒ肷B<p>
     *
     * @param name QueueHandlerT[rX̃T[rX
     */
    public void setQueueHandlerServiceName(ServiceName name);
    
    /**
     * {@link QueueHandler}T[rX̃T[rX擾B<p>
     *
     * @return QueueHandlerT[rX̃T[rX
     */
    public ServiceName getQueueHandlerServiceName();
    
    /**
     * L[҂󂯂{@link QueueHandler}Xbh̐ݒ肷B<p>
     * ftHǵA1B<br>
     *
     * @param size QueueHandlerXbh̐
     */
    public void setQueueHandlerSize(int size);
    
    /**
     * L[҂󂯂{@link QueueHandler}Xbh̐擾B<p>
     *
     * @return QueueHandlerXbh̐
     */
    public int getQueueHandlerSize();
    
    /**
     * T[rX̒~{@link Queue#release()}ĂяoAQueueJ邩ǂݒ肷B<p>
     * ftHǵAtrueBPQueue𕡐̃ReiŎQƂꍇ́AfalseɂׂłB<br>
     *
     * @param isRelease Jꍇtrue
     */
    public void setReleaseQueue(boolean isRelease);
    
    /**
     * T[rX̒~{@link Queue#release()}ĂяoAQueueJ邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇ́AJ
     */
    public boolean isReleaseQueue();
    
    /**
     * L[҂󂯂ő厞[ms]ݒ肷B<p>
     * ^CAEgꍇ́A{@link QueueHandler#handleDequeuedObject(Object)     }nullnB<br>
     *
     * @param timeout L[҂󂯂ő厞[ms]
     */
    public void setWaitTimeout(long timeout);
    
    /**
     * L[҂󂯂ő厞[ms]擾B<p>
     *
     * @return L[҂󂯂ő厞[ms]
     */
    public long getWaitTimeout();
    
    /**
     * nhO̍ۂɃG[ꍇɃgC񐔂ݒ肷B<p>
     * ftHǵA0ŃgCȂB<br>
     *
     * @param count gC
     */
    public void setMaxRetryCount(int count);
    
    /**
     * nhO̍ۂɃG[ꍇɃgC񐔂擾B<p>
     *
     * @return gC
     */
    public int getMaxRetryCount();
    
    /**
     * nhO̍ۂɃG[ꍇɃgCԊuݒ肷B<p>
     * ftHǵA1000[ms]B<br>
     *
     * @param interval gCԊu
     */
    public void setRetryInterval(long interval);
    
    /**
     * nhO̍ۂɃG[ꍇɃgCԊu擾B<p>
     *
     * @return gCԊu
     */
    public long getRetryInterval();
    
    /**
     * nhO̍ۂɃG[ʒm郍ÕbZ[WIDݒ肷B<p>
     * ftHǵA{@link #DEFAULT_HANDLING_ERROR_MESSAGE_ID}B<br>
     *
     * @param id ÕbZ[WID
     */
    public void setHandlingErrorMessageId(String id);
    
    /**
     * nhO̍ۂɃG[ʒm郍ÕbZ[WID擾B<p>
     *
     * @return ÕbZ[WID
     */
    public String getHandlingErrorMessageId();
    
    /**
     * nhO̍ۂɃG[AgC񐔂zʒm郍ÕbZ[WIDݒ肷B<p>
     * ftHǵA{@link #DEFAULT_RETRY_OVER_ERROR_MESSAGE_ID}B<br>
     *
     * @param id ÕbZ[WID
     */
    public void setRetryOverErrorMessageId(String id);
    
    /**
     * nhO̍ۂɃG[AgC񐔂zʒm郍ÕbZ[WID擾B<p>
     *
     * @return ÕbZ[WID
     */
    public String getRetryOverErrorMessageId();
    
    /**
     * ݃nhÕXbh擾B<p>
     *
     * @return ݃nhÕXbh
     */
    public int getActiveQueueHandlerSize();
    
    /**
     * ݑҋ@̃Xbh擾B<p>
     *
     * @return ݑҋ@̃Xbh
     */
    public int getStandbyQueueHandlerSize();
    
    /**
     * L[҂󂯂{@link QueueHandler}Xbhf[Xbhɂ邩ǂݒ肷B<p>
     * ftHǵAtrueB<br>
     *
     * @param isDaemon f[Xbhɂꍇ́Atrue
     */
    public void setDaemonQueueHandler(boolean isDaemon);
    
    /**
     * L[҂󂯂{@link QueueHandler}Xbhf[Xbhɂ邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAf[Xbhɂ
     */
    public boolean isDaemonQueueHandler();
    
    /**
     * L[҂󂯂{@link QueueHandler}Xbh̗D揇ʂݒ肷B<p>
     * ftHǵA-1Őݒ肵ȂB<br>
     *
     * @param newPriority Xbh̗D揇
     */
    public void setQueueHandlerThreadPriority(int newPriority);
    
    /**
     * L[҂󂯂{@link QueueHandler}Xbh̗D揇ʂ擾B<p>
     *
     * @return Xbh̗D揇
     */
    public int getQueueHandlerThreadPriority();
    
    /**
     * T[rX̒~{@link QueueHandler}Xbh̏Iҋ@Ȃǂݒ肷B<p>
     * ftHǵAfalseőҋ@B
     *
     * @param isNowait ҋ@Ȃꍇtrue
     */
    public void setQueueHandlerNowaitOnStop(boolean isNowait);
    
    /**
     * T[rX̒~{@link QueueHandler}Xbh̏Iҋ@Ȃǂ𔻒肷B<p>
     *
     * @return ҋ@Ȃꍇtrue
     */
    public boolean isQueueHandlerNowaitOnStop();
    
    /**
     * L[̏Ԃ̕ς擾B<p>
     *
     * @return Ϗ[ms]
     */
    public long getAverageHandleProcessTime();
    
    /**
     * ĊJB<p>
     */
    public void resume();
    
    /**
     * fB<p>
     */
    public void suspend();
    
    /**
     * fĂ邩ǂ𔻒肷B<p>
     *
     * @return fĂꍇAtrue
     */
    public boolean isSuspend();
}