/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina;

import junit.framework.TestCase;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/10/15
 */
public class NinaRecursiveTest extends TestCase {

	static void mat(NinaPattern m, String s) {
		NinaMatcher x;

		x = m.matcher(s);
		assertTrue(x.matches());
	}

	static void nmt(NinaPattern m, String s) {
		NinaMatcher x;

		x = m.matcher(s);
		assertFalse(x.matches());
	}

	public void test0001() throws Exception {
		NinaPattern m;

		m = Nina.patternResource("/net/morilib/nina/t03.nina");
		mat(m, "ab");  
		mat(m, "aaabbb");
		mat(m, "aaaaabbbbb");
	}

}
