/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import net.morilib.range.Interval;
import net.morilib.range.Range;
import net.morilib.range.RangeAdder;

public class NinaMap<T, V> implements TinyMap<T, V> {

	private Map<T, V> map;

	NinaMap() {
		map = new HashMap<T, V>();
	}

	void put(T key, V value) {
		map.put(key, value);
	}

	@Override
	public V get(T key) {
		return map.get(key);
	}

	@Override
	public V get(Range keys) {
		for(Map.Entry<T, V> e : map.entrySet()) {
			if(e.getKey() == null) {
				return keys.equals(Range.O) ? e.getValue() : null;
			} else if(keys.equals(Interval.newPoint(e.getKey()))) {
				return e.getValue();
			}
		}
		return null;
	}

	@Override
	public Range getKeyRange() {
		RangeAdder a = new RangeAdder();

		for(Map.Entry<T, V> e : map.entrySet()) {
			if(e.getKey() == null) {
				a.addInterval(Range.O);
			} else {
				a.addInterval(Interval.newPoint(e.getKey()));
			}
		}
		return a.toRange();
	}

	@Override
	public Set<T> getDiscreteKeys() {
		Set<T> s = new HashSet<T>(map.keySet());

		s.remove(null);
		return s;
	}

	public String toString() {
		StringBuffer b = new StringBuffer();
		String d = "";

		for(Map.Entry<T, V> e : map.entrySet()) {
			b.append(d).append("<<").append(e.getKey());
			b.append(" , ").append(e.getValue()).append(">>");
			d = "\n";
		}
		return b.toString();
	}

	@Override
	public Set<V> valueSet() {
		return new HashSet<V>(map.values());
	}

}
