/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina;

import net.morilib.automata.NFAState;

public class NinaState implements NFAState {

	private Object label, parser;

	NinaState(Object p, Object l) {
		parser = p;
		label = l;
	}

	public Object getLabel() {
		return label;
	}

	public int hashCode() {
		return label.hashCode();
	}

	public boolean equals(Object o) {
		return (o instanceof NinaState &&
				parser.equals(((NinaState)o).parser) &&
				label.equals(((NinaState)o).label));
	}

	public String toString() {
		return label == null ? "" : label.toString();
	}

}
