/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina;

import net.morilib.automata.NFAState;
import net.morilib.automata.dfa.ConvertedDFA;
import net.morilib.automata.dfa.DFA;
import net.morilib.automata.dfa.DFAs;
import net.morilib.automata.regular.BasicRegex;
import net.morilib.nina.Quadro;
import net.morilib.nina.NinaParser;
import junit.framework.TestCase;

public class NinaSubAutomataTest extends TestCase {

	static<T> void drv(String s, boolean pause) {
		DFA<T, NFAState, Void> d;
		NinaParser<T> m;
		BasicRegex b;
		Quadro q;

		q = Quadro.read(s);
		m = new NinaParser<T>(q);
		try {
			while(!m.step()) {
				if(pause) {
					System.in.read();
					System.out.println(m.etat);
					System.out.println(m.q.toString());
				}
			}
			System.out.print(m.nfa);
			d = ConvertedDFA.convertDFA(m.nfa);
			b = DFAs.convertToRegex(d);
			System.out.println(b);
			System.out.println("-------------------------------");
		} catch(Exception e) {
			System.out.println(m.etat);
			System.out.println(m.q.get() < 0 ? m.q.get() : (char)m.q.get());
			throw new RuntimeException(e);
		}
	}

	public void test0001() {
		String s =
				" =======                                @*****\n" +
				" =aaa  >--{/net/morilib/nina/t01.nina}-->aa  *\n" +
				" ==^====                                **v***\n" +
				"   \\--------------------b-----------------/  \n" +
				"";

		NinaSubAutomataTest.<Character>drv(s, false);
	}

	public void test0002() {
		String s =
				" =======                                @*****\n" +
				" =aaa  >--{/net/morilib/nina/t02.nina}-->aa  *\n" +
				" =======                                ******\n" +
				"";

		NinaSubAutomataTest.<Character>drv(s, false);
	}

}
