/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina.cmd;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;

import net.morilib.nina.translate.AbstractNinaTranslator;
import net.morilib.nina.translate.NinaTranslator;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/10/23
 */
public class Ninat {

	private static NinatOptions opts;

	static int parseOptions(String[] args) {
		NinaTranslator t;
		int k = 0, x;
		String s;

		for(; k < args.length; k++) {
			s = args[k];
			if(s.equals("-J")) {
				opts.jflag = true;
			} else if(!s.startsWith("--")) {
				return k;
			} else if(s.equals("--help")) {
				opts.usage();
				System.exit(2);
			} else if(s.startsWith("--lang=")) {
				t = AbstractNinaTranslator.getTranslator(
						s.substring(7));
				opts.setTranslator(t);
				opts.jflag = false;
			} else if((x = s.indexOf('=')) < 0) {
				opts.setOption(s.substring(2), "");
			} else {
				opts.setOption(s.substring(2, x), s.substring(x + 1));
			}
		}
		return k;
	}

	static void process(String arg) {
		InputStream ins = null;
		NinaTranslator tr;
		Reader rd = null;
		String s, t;
		int x;

		if(arg.endsWith("/")) {
			opts.perror("filenotfound", arg);
			return;
		} else if((x = arg.lastIndexOf('.')) < 0) {
			s = arg + ".nina";
			t = arg;
		} else {
			s = arg;
			t = arg.substring(0, x);
		}

		if((x = t.lastIndexOf('/')) < 0) {
			opts.setFilename(t);
		} else {
			opts.setFilename(t.substring(x + 1));
		}

		try {
			ins = new FileInputStream(s);
			rd  = new InputStreamReader(ins);
			tr  = opts.getTranslator();
			if(tr == null) {
				opts.perror("languagenotsupport");
				System.exit(2);
			}
			tr.translate(rd, opts);
		} catch(FileNotFoundException e) {
			opts.perror("filenotfound", s);
		} catch(IOException e) {
			throw new RuntimeException(e);
		} finally {
			if(ins != null) {
				try {
					ins.close();
				} catch (IOException e) {
					throw new RuntimeException(e);
				}
			}
		}
	}

	/**
	 * 
	 * @param args
	 */
	public static void main(String[] args) {
		JavaCompiler cp;
		int k, x;

		opts = new NinatOptions();
		if(args.length == 0) {
			opts.usage();
			System.exit(2);
		} else if((k = parseOptions(args)) == args.length) {
			opts.perror("nofiles");
			System.exit(2);
		} else {
			for(; k < args.length; k++) {
				process(args[k]);
			}

			if(opts.jflag) {
				try {
					cp = ToolProvider.getSystemJavaCompiler();
					x  = cp.run(null, null, null,
							opts.getJavaFile().toString());
					System.exit(x);
				} catch(Exception e) {
					opts.perror("javacompiler");
					System.exit(4);
				}
			} else {
				System.exit(0);
			}
		}
	}

}
