/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina.cmd;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

import net.morilib.nina.Nina;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/10/23
 */
public class ZNinaOptions {

	private static final String CLSNAME =
			ZNina.class.getPackage().getName().replace('.', '/');

	private Map<String, String> opts = new HashMap<String, String>();
	private static ResourceBundle msgs;

	/**
	 * 
	 */
	public ZNinaOptions() {
		msgs = ResourceBundle.getBundle(CLSNAME + "/znina_messages");
	}

	/**
	 * 
	 * @param p
	 * @param a
	 */
	public void print(String p, Object... a) {
		System.out.format(msgs.getString(p), a);
		System.out.println();
	}

	/**
	 * 
	 * @param p
	 * @param a
	 */
	public void perror(String p, Object... a) {
		System.out.print(msgs.getString("errorheader"));
		System.out.format(msgs.getString(p), a);
		System.out.println();
	}

	/**
	 * 
	 * @param p
	 * @param a
	 */
	public void pwarn(String p, Object... a) {
		System.out.print(msgs.getString("warnheader"));
		System.out.format(msgs.getString(p), a);
		System.out.println();
	}

	/**
	 * 
	 * @param p
	 * @param a
	 */
	public void pmessage(String p) {
		System.out.print(msgs.getString("errorheader"));
		System.out.println(p);
	}

	/**
	 * 
	 */
	public void usage() {
		int l = Integer.parseInt(msgs.getString("usage.length"));
		String x;

		print("title", Nina.VERSION);
		for(int i = 1; i <= l; i++) {
			x = String.format("%03d", i);
			print("usage." + x);
		}
	}

	/**
	 * 
	 * @param key
	 * @return
	 */
	public String getOption(String key) {
		String s;

		return (s = opts.get(key)) != null ? s : "";
	}

	/**
	 * 
	 * @param key
	 * @return
	 */
	public int getOptionInt(String key, int def) {
		String s;

		try {
			if((s = getOption(key)).equals("")) {
				return def;
			} else {
				return Integer.parseInt(s);
			}
		} catch(NumberFormatException e) {
			perror("notanumber", key);
			System.exit(2);
			return -1;  // dead code
		}
	}

	//
	void setOption(String key, String value) {
		opts.put(key, value);
	}

}
