/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh;

import java.io.InputStream;
import java.io.PrintStream;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/10/25
 */
public abstract class AbstractShVirtualDirectory implements ShFile {

	private String current;
	private ShFile parent;

	public AbstractShVirtualDirectory(ShFile parentFile,
			String currentName) {
		if(parentFile != null && currentName == null) {
			throw new NullPointerException();
		}
		parent  = parentFile;
		current = currentName;
	}

	public InputStream getInputStream() {
		return null;
	}

	public String getName() {
		return current != null ? current : "";
	}

	public PrintStream getPrintStream(boolean append) {
		return null;
	}

	public boolean isDirectory() {
		return true;
	}

	public boolean isExecutable() {
		return true;
	}

	public boolean isExist() {
		return true;
	}

	public boolean isFile() {
		return false;
	}

	public long getLastModified() {
		return Long.MIN_VALUE;
	}

	public boolean isReadable() {
		return true;
	}

	public boolean isWritable() {
		return true;
	}

	public boolean isHidden() {
		return false;
	}

	public boolean isZeroFile() {
		return false;
	}

	public ShProcess getProcess() {
		return null;
	}

	public ShFile toAbsolute() {
		return this;
	}

	public ShFile toCanonical() {
		return this;
	}

	public boolean mkdir() {
		return false;
	}

	public boolean renameTo(ShFile f) {
		return false;
	}

	public void setLastModified(long time) {
		// do nothing
	}

	public boolean rmdir() {
		return false;
	}

	public boolean deleteFile() {
		return false;
	}

	public ShStat getStat() {
		return new ShStat(toString(), 0, 0,
				ShStat.DIRECTORY | ShStat.EXECUTABLE |
				ShStat.READABLE  | ShStat.WRITABLE);
	}

	public String toString() {
		return (parent != null ? parent.toString() : "")
				+ "/" + getName();
	}

}
