/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

import net.morilib.automata.DFA;
import net.morilib.automata.NFA;
import net.morilib.automata.NFAState;
import net.morilib.math.stochastic.GenerateRandomSequence;
import net.morilib.math.stochastic.StochasticProcess;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/10/19
 */
public class ZNina {

	private static int kanon = 0;

	private static String repond(boolean b) {
		if(kanon > 0) {
			return b ? "hachimitsukumasan" : "pompokotanukisan";
		} else {
			return b ? "matched" : "no match";
		}
	}

	private static void _match(NinaPattern p) throws IOException {
		BufferedReader rd = new BufferedReader(
				new InputStreamReader(System.in));
		String s;

		System.out.print("match> ");
		while((s = rd.readLine()) != null && !s.equals("exit")) {
			System.out.println(repond(p.matcher(s).matches()));
			System.out.print("match> ");
		}
	}

	@SuppressWarnings("unchecked")
	public static void main(String[] args) {
		InputStream ins = null;
		Reader rd;
		int k = 0;
		Object o;

		if(args.length - k >= 1 && args[k].equals("--kanon")) {
			kanon = ++k;
		}

		if(args.length - k < 1) {
			System.err.println("filename required");
			System.exit(2);
		}

		try {
			ins = new FileInputStream(args[k]);
			rd  = new InputStreamReader(ins);
			o   = Nina.compile(rd);
			if(o instanceof NFA) {
				_match(new NinaNFAPattern(
						(NFA<Object, NFAState, Void>)o));
			} else if(o instanceof DFA) {
				_match(new NinaDFAPattern(
						(DFA<Object, Object, Void>)o));
			} else if(o instanceof StochasticProcess) {
				System.out.println(GenerateRandomSequence.generate(
						(StochasticProcess)o,
						args.length - k < 2 ? "" : args[k + 1]));
			}
			System.exit(0);
		} catch(IOException e) {
			throw new RuntimeException(e);
		} finally {
			try {
				if(ins != null) ins.close();
			} catch (IOException e) {
				throw new RuntimeException(e);
			}
		}
	}

}
