/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.unix.misc;

/**
 * 32ビット文字の並びをあらわすインターフェースです。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public interface WideCharSequence {

	/**
	 * 与えられた場所の文字を得ます。
	 * 
	 * @param index 場所
	 * @return 文字
	 */
	public int charAt(int index);

	/**
	 * 文字の並びの長さを得ます。
	 * 
	 * @return 長さ
	 */
	public int length();

	/**
	 * 部分文字並びを得ます。
	 * 
	 * @param start 0で始まる始点
	 * @param end   終点(この場所は含みません)
	 * @return 部分文字並び
	 */
	public WideCharSequence subSequence(int start, int end);

	/**
	 * Java標準文字列に変換します。
	 * 
	 * @return Java文字列
	 */
	public String toString();

}
