/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina;

import junit.framework.TestCase;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/10/13
 */
public class NinaMatcherTest extends TestCase {

	static void mat(NinaPattern m, String s) {
		NinaMatcher x;

		x = m.matcher(s);
		assertTrue(x.matches());
	}

	static void nmt(NinaPattern m, String s) {
		NinaMatcher x;

		x = m.matcher(s);
		assertFalse(x.matches());
	}

	static void lok(NinaPattern m, String s, String d) {
		NinaMatcher x;

		x = m.matcher(s);
		assertTrue(x.lookingAt());
		assertEquals(d, x.group());
	}

	static void fnd(NinaPattern m, String s, String d) {
		NinaMatcher x;

		x = m.matcher(s);
		assertTrue(x.find());
		assertEquals(d, x.group());
	}

	public void test0001() {
		String s =
				"#machine NFABuilder\n" +
				" =======                                @*****\n" +
				" =aaa  >-----------------a-------------->aa  *\n" +
				" ==^====                                **v***\n" +
				"   \\-------------------[a-z]--------------/  \n" +
				"";
		NinaPattern m;

		m = Nina.pattern(s);
		mat(m, "a");  
		mat(m, "aaa");
		mat(m, "aaaaa");
		nmt(m, "");
		nmt(m, "aa");
		nmt(m, "aaaa");
		mat(m, "a");  
		mat(m, "aba");
		mat(m, "abada");

		lok(m, "aza", "aza");
		lok(m, "azaz", "aza");
		assertFalse(m.matcher("baza").lookingAt());

		fnd(m, "baza", "aza");
		fnd(m, "zbazaz", "aza");
		assertFalse(m.matcher("bbb").find());
	}

	public void test0002() {
		String s =
				"#machine DFABuilder\n" +
				" =======                                @*****\n" +
				" =aaa  >-----------------a-------------->aa  *\n" +
				" ==^====                                **v***\n" +
				"   \\-------------------[b-z]--------------/  \n" +
				"";
		NinaPattern m;

		m = Nina.pattern(s);
		assertTrue(m.matcher("a").matches());  
		assertTrue(m.matcher("aba").matches());
		assertTrue(m.matcher("ababa").matches());
		assertFalse(m.matcher("").matches());
		assertFalse(m.matcher("ab").matches());
		assertFalse(m.matcher("abab").matches());
		assertTrue(m.matcher("a").matches());  
		assertTrue(m.matcher("aba").matches());
		assertTrue(m.matcher("abada").matches());

		lok(m, "aza", "aza");
		lok(m, "azaz", "aza");
		assertFalse(m.matcher("baza").lookingAt());

		fnd(m, "baza", "aza");
		fnd(m, "zbazaz", "aza");
		assertFalse(m.matcher("bbb").find());
	}

	public void test0003() {
		String s =
				"#machine NFABuilder\n" +
				" =======     *****                      @*****\n" +
				" =aaa  >----->b  >-------a-------------->aa  *\n" +
				" =======     **v**                      **^***\n" +
				"               \\---------b----------------/  \n" +
				"";
		NinaPattern m;

		m = Nina.pattern(s);
		mat(m, "a");  
		mat(m, "b");
		nmt(m, "");
		nmt(m, "ab");
		nmt(m, "ba");
	}

	public void test0004() {
		String s =
				"#machine NFABuilder\n" +
				" =======                                @*****\n" +
				" =aaa  >----------------`a+`------------>aa  *\n" +
				" ==^====                                **v***\n" +
				"   \\-------------------[c-z]--------------/  \n" +
				"";
		NinaPattern m;

		m = Nina.pattern(s);
		mat(m, "a");
		mat(m, "aaca");
		mat(m, "aaacaa");
		nmt(m, "");
		nmt(m, "aac");
		nmt(m, "aaaac");

		lok(m, "aaza", "aaza");
		lok(m, "aazaz", "aaza");
		assertFalse(m.matcher("baza").lookingAt());

		fnd(m, "baaza", "aaza");
		fnd(m, "zbazaaz", "azaa");
		assertFalse(m.matcher("bbb").find());
	}

	public void test0005() {
		String s =
				"#machine NFABuilder\n" +
				" =======                                @*****\n" +
				" =aaa  >-------------`(ab)+`------------>aa  *\n" +
				" ==^====                                **v***\n" +
				"   \\-------------------[c-z]--------------/  \n" +
				"";
		NinaPattern m;

		m = Nina.pattern(s);
		mat(m, "ab");
		mat(m, "ababcab");
		mat(m, "abababcabab");
		nmt(m, "");
		nmt(m, "ababc");
		nmt(m, "ababababc");
		nmt(m, "abababacab");
	}

	public void test0006() {
		String s =
				"#machine DFABuilder\n" +
				"   /a------------------\\  \n" +
				" ==^====             @*v***\n" +
				" =aaa  =             *aa  *\n" +
				" ==^====             **v***\n" +
				"   \\------------------b/  \n" +
				"";
		NinaPattern m;

		m = Nina.pattern(s);
		mat(m, "aba");
	}

}
