/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina.translate;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

import net.morilib.automata.DFAState;
import net.morilib.automata.NFAState;
import net.morilib.range.Interval;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/10/23
 */
public class NinaTranslatorJava extends AbstractNinaTranslator {

	private int stateNo = 0;
	private Map<Object, Integer> states =
			new IdentityHashMap<Object, Integer>();
	private Set<Integer> accepts = new HashSet<Integer>();
	private Stack<DFAState<Object, NFAState, Void>> trz =
			new Stack<DFAState<Object, NFAState, Void>>();

	//
	private void printintv(PrintStream out, Interval v, boolean els) {
		String s, t, a;

		s = v.isInfimumClosed() ? ">=" : ">";
		t = v.isSupremumClosed() ? "<=" : "<";
		a = els ? "\t\t\t} else if" : "\t\t\tif";
		out.format("%s(c %s %d && c %s %d) {\n",
				a, s, ((Integer)v.getInfimumBound()).intValue(),
				t, ((Integer)v.getSupremumBound()).intValue());
		
	}

	//
	private void printState(PrintStream out,
			DFAState<Object, NFAState, Void> dfa) {
		DFAState<Object, NFAState, Void> d;
		int sn = getStateNo(dfa), c;
		boolean els = false;

		out.format("\t\tcase %d:\n", sn);
		for(Interval v : dfa.getAlphabetRanges()) {
			printintv(out, v, els);
			c = ((Integer)v.getInfimumBound()).intValue();
			if(v.isInfimumOpen())  c++;
			d = dfa.goInt(c);
			out.format("\t\t\t\tstate = %d;\n", getStateNo(d));
			els = true;
		}
		out.println("\t\t\t}");
		out.println("\t\t\tbreak;");
	}

	/**
	 * 
	 * @param state
	 * @return
	 */
	private int getStateNo(DFAState<Object, NFAState, Void> state) {
		if(states.containsKey(state)) {
			return states.get(state);
		} else {
			states.put(state, stateNo);
			if(state.isAccepted())  accepts.add(stateNo);
			trz.push(state);
			return stateNo++;
		}
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.translate.AbstractNinaTranslator#printStates(java.io.PrintStream)
	 */
	@Override
	protected void printStates(PrintStream out) {
		DFAState<Object, NFAState, Void> s;

		s = dfa.getInitialState();
		states.put(s, stateNo++);
		trz.push(s);
		while(!trz.isEmpty()) {
			s = trz.pop();
			printState(out, s);
		}
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.translate.AbstractNinaTranslator#printAcceptStates(java.io.PrintStream)
	 */
	@Override
	protected void printAcceptStates(PrintStream out) {
		String d = "\t\treturn (";

		if(accepts.size() == 0) {
			out.println("\t\treturn false;");
		} else {
			for(Integer i : accepts) {
				out.print(d);
				out.format("state == %d", i);
				d = " ||\n\t\t\t\t";
			}
			out.println(");");
		}
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.translate.AbstractNinaTranslator#openScript()
	 */
	@Override
	protected InputStream openScript() {
		return NinaTranslator.class.getResourceAsStream(
				"/net/morilib/nina/translate/nina_template.java.sh");
	}

	/* (non-Javadoc)
	 * @see net.morilib.nina.translate.AbstractNinaTranslator#openOutput()
	 */
	@Override
	protected PrintStream openOutput() throws IOException {
		return new PrintStream(new FileOutputStream(
				options.getFilename() + ".java"), true);
	}

}
