# -*- coding: utf-8 -*-
#
#  osuwari.py - a Osuwari compatible Saori module for ninix
#  Copyright (C) 2006-2012 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
#

# TODO: MOVE, NOCLIP, FIX, etc.

from gi.repository import Gdk
from gi.repository import GLib

from ninix.dll import SAORI
import ninix.pix


class Saori(SAORI):

    def __init__(self):
        SAORI.__init__(self)
        self.timeout_id = None
        self.settings = {}
        self.__sakura = None

    def need_ghost_backdoor(self, sakura):
        self.__sakura = sakura

    def check_import(self):
        return 1 if self.__sakura else 0

    def setup(self): ## FIXME
        return 1

    def execute(self, argument):
        if not argument:
            return self.RESPONSE[400]
        if argument[0] == 'START':
            if len(argument) < 7:
                return self.RESPONSE[400]
            try:
                assert argument[2] in ['ACTIVE', 'FIX'] or \
                       argument[2].stratswith('@') or \
                       argument[2].startswith('#')
                assert argument[3] in ['TL', 'TR', 'BL', 'BR']
                self.settings['hwnd'] = argument[1]
                self.settings['target'] = argument[2]
                self.settings['position'] = argument[3]
                self.settings['offset_x'] = int(argument[4])
                self.settings['offset_y'] = int(argument[5])
                self.settings['timeout'] = int(argument[6])
                self.settings['xmove'] = 0
                self.settings['ymove'] = 0
                self.settings['noclip'] = 0
                if len(argument) > 7:
                    if 'XMOVE' in argument[7]:
                        self.settings['xmove'] = 1
                    if 'YMOVE' in argument[7]:
                        self.settings['ymove'] = 1
                    if 'NOCLIP' in argument[7]:
                        self.settings['noclip'] = 1
                self.settings['except'] = ('DESKTOP', 'CENTER')
                if len(argument) > 8:
                    #target, position = argument[8].split() # spec
                    position, target = argument[8].split() # real world
                    assert target in ['DESKTOP', 'WORKAREA']
                    assert position in ['TOP', 'LEFT', 'RIGHT', 'BOTTOM']
                    self.settings['except'] = (target, position)
            except:
                return self.RESPONSE[400]
            #self.timeout_id = GLib.timeout_add(self.settings['timeout'], self.do_idle_tasks)
            self.timeout_id = GLib.timeout_add(100, self.do_idle_tasks)
            return self.RESPONSE[204]
        elif argument[0] == 'STOP':
            if self.timeout_id is not None:
                GLib.source_remove(self.timeout_id)
                self.timeout_id = None
                self.settings = {}
            return self.RESPONSE[204]
        else:
            return self.RESPONSE[400]

    def do_idle_tasks(self):
        if self.timeout_id is None:
            return False
        target = self.settings['target']
        left, top, scrn_w, scrn_h = ninix.pix.get_workarea()
        target_flag = [False, False]
        if target == 'ACTIVE':
            active_window = self.get_active_window()
            if active_window:
                if self.__sakura.identify_window(active_window):
                    target_flag[1] = True
                else:
                    rect = active_window.get_frame_extents()
                    target_x = rect.x
                    target_y = rect.y
                    target_w = rect.width
                    target_h = rect.height
                    target_flag[0] = True
            else:
                target_flag[1] = True
        elif target == 'FIX': ## FIXME
            target_x = left
            target_y = top
            target_w = scrn_w
            target_h = scrn_h
            target_flag[0] = True
        elif target.startswith('@'): ## FIXME
            #win = self.get_window_by_name(target[1:])
            #if self.__sakura.identify_window(win):
            #    return True
            #target_x, target_y = active_window.get_root_origin()
            #rect = active_window.get_frame_extents()
            #target_w = rect.width
            #target_h = rect.height
            pass
        elif target.startswith('#'): ## FIXME
            pass
        else:
            pass # should not reach here
        if not target_flag[0]:
            return target_flag[1]
        pos = self.settings['position']
        scale = self.__sakura.get_surface_scale()
        offset_x = int(self.settings['offset_x'] * scale / 100)
        offset_y = int(self.settings['offset_y'] * scale / 100)
        if self.settings['hwnd'].startswith('s'):
            try:
                side = int(self.settings['hwnd'][1:])
            except:
                return False
        else:
            try:
                side = int(self.settings['hwnd'])
            except:
                return False
        w, h = self.__sakura.get_surface_size(side)
        if pos[0] == 'T':
            y = target_y + offset_y
        elif pos[0] == 'B':
            y = target_y + target_h + offset_y - h
        else:
            return False # should not reach here
        if pos[1] == 'L':
            x = target_x + offset_x
        elif pos[1] == 'R':
            x = target_x + target_w + offset_x - w
        else:
            return False # should not reach here
        if not self.settings['noclip']:
            if x < left or x > left+ scrn_w or \
                    y < top or y > top + scrn_h:
                if self.settings['except'][1] == 'BOTTOM':
                    pass ## FIXME
                elif self.settings['except'][1] == 'TOP':
                    pass ## FIXME
                elif self.settings['except'][1] == 'LEFT':
                    pass ## FIXME
                elif self.settings['except'][1] == 'RIGTH':
                    pass ## FIXME
                elif self.settings['except'][1] == 'CENTER':
                    pass ## FIXME
                else:
                    pass # should not reach here
        self.__sakura.set_surface_position(side, x, y)
        self.__sakura.raise_surface(side)
        return True

    def get_window_by_name(self, name): ## FIXME
        return None

    def get_active_window(self):
        scrn = Gdk.Screen.get_default()
        active_window = scrn.get_active_window()
        return active_window
