﻿//  MeCab -- Yet Another Part-of-Speech and Morphological Analyzer
//
//  Copyright(C) 2001-2006 Taku Kudo <taku@chasen.org>
//  Copyright(C) 2004-2006 Nippon Telegraph and Telephone Corporation
using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace NMeCab.Core
{
    public struct Token
    {
        /// <summary>
        /// 右文脈 id
        /// </summary>
        public readonly ushort LcAttr;

        /// <summary>
        /// 左文脈 id
        /// </summary>
        public readonly ushort RcAttr;

        /// <summary>
        /// 形態素 ID
        /// </summary>
        public readonly ushort PosId;

        /// <summary>
        /// 単語生起コスト
        /// </summary>
        public readonly short WCost;

        /// <summary>
        /// 素性情報の位置
        /// </summary>
        public readonly uint Feature;

        /// <summary>
        /// reserved for noun compound
        /// </summary>
        public readonly uint Compound;
        
        public Token(BinaryReader reader)
        {
            this.LcAttr = reader.ReadUInt16();
            this.RcAttr = reader.ReadUInt16();
            this.PosId = reader.ReadUInt16();
            this.WCost = reader.ReadInt16();
            this.Feature = reader.ReadUInt32();
            this.Compound = reader.ReadUInt32();
        }

        public override string ToString()
        {
            return string.Format("[LcAttr:{0}][RcAttr:{1}][PosId:{2}][WCost:{3}][Feature:{4}][Compound:{5}]",
                                 this.LcAttr,
                                 this.RcAttr,
                                 this.PosId,
                                 this.WCost,
                                 this.Feature,
                                 this.Compound);
        }
    }
}
