package org.mineap.a2n4as
{
	import flash.events.Event;
	import flash.events.ErrorEvent;
	import flash.events.IOErrorEvent;
	import flash.events.SecurityErrorEvent;
	import flash.events.HTTPStatusEvent;
	import flash.events.EventDispatcher;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	
	[Event(name="success", type="IchibaInfoLoader")]
	[Event(name="fail", type="IchibaInfoLoader")]
	[Event(name="httpResponseStatus", type="HTTPStatusEvent")]
	
	/**
	 * 市場情報を取得するクラスです。
	 * 
	 * @author shiraminekeisuke
	 * 
	 */
	public class IchibaInfoLoader extends EventDispatcher
	{
		
		public static const SUCCESS:String = "Success";
		
		public static const FAIL:String = "Fail";
		
		private var _ichibaLoader:URLLoader;
		
		public function IchibaInfoLoader()
		{
		}
		
		/**
		 * 市場情報を取得します。
		 * 
		 * @param videoId
		 * 
		 */
		public function getIchibaInfo(videoId:String):void{
			
			this._ichibaLoader = new URLLoader();
			
			//市場情報サーバーの負荷分散
			var balance:int = (Math.random()*100)%5;
			if(balance == 0){
				balance++;
			}
			var url:String = "http://ichiba" +balance+ ".nicovideo.jp/embed/?action=showMain&v="+ videoId +"&rev=20090122";
			
			this._ichibaLoader.addEventListener(Event.COMPLETE, ichibaInfoLoadComplete);
			this._ichibaLoader.addEventListener(IOErrorEvent.IO_ERROR, errorEventHandler);
			this._ichibaLoader.addEventListener(SecurityErrorEvent.SECURITY_ERROR, errorEventHandler);
			this._ichibaLoader.addEventListener(HTTPStatusEvent.HTTP_RESPONSE_STATUS, httpResponseStatusEventHandler);
			
			this._ichibaLoader.load(new URLRequest(url));
			
		}
		
		/**
		 * 
		 * @param event
		 * 
		 */
		private function ichibaInfoLoadComplete(event:Event):void{
			dispatchEvent(new Event(SUCCESS));
			removeAllHandler();
			close();
		}
		
		/**
		 * 
		 * @param event
		 * 
		 */
		private function errorEventHandler(event:ErrorEvent):void{
			dispatchEvent(new ErrorEvent(FAIL, false, false, event.text));
			removeAllHandler();
			close();
		}
		
		/**
		 * 
		 * @param event
		 * 
		 */
		private function httpResponseStatusEventHandler(event:HTTPStatusEvent):void{
			dispatchEvent(event);
		}
		
		/**
		 * 
		 * @param target
		 * 
		 */
		private function removeAllHandler():void{
			this._ichibaLoader.removeEventListener(Event.COMPLETE, ichibaInfoLoadComplete);
			this._ichibaLoader.removeEventListener(HTTPStatusEvent.HTTP_RESPONSE_STATUS, httpResponseStatusEventHandler);
			this._ichibaLoader.removeEventListener(IOErrorEvent.IO_ERROR, errorEventHandler);
			this._ichibaLoader.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, errorEventHandler);
		}
		
		/**
		 * 市場情報取得APIにアクセスしたURLLoaderのdataを返します。
		 * @return 
		 * 
		 */
		public function get data():Object{
			return this._ichibaLoader.data;
		}
		
		/**
		 * 
		 * 
		 */
		public function close():void{
			try{
				this._ichibaLoader.close();
			}catch(error:Error){
				trace(error.getStackTrace());
			}
//			this._ichibaLoader = null;
		}

	}
}