/*  Header file for D-STAR 	*/
/*  		Satoshi Yasuda	*/
/*		7m3tjz/ad6gz	*/

struct	dv_header{
	unsigned char	flags[3];
	unsigned char	RPT2Call[8];
	unsigned char	RPT1Call[8];
	unsigned char	YourCall[8];
	unsigned char	MyCall[8];
	unsigned char	MyCall2[4];
	unsigned char	CRC[2];
};

struct	back_bone{
	unsigned char	id;
	unsigned char	dest_repeater_id;
	unsigned char	send_repeater_id;
	unsigned char	send_terminal_id;
	unsigned char	seq_high;
	unsigned char	seq_low;
	unsigned char	control;
};

struct	voice_data{
	unsigned char	voice_segment[9];
	unsigned char	data_segment[3];
};

struct	dv_buffer{
	unsigned char	buff[41];
};

struct inet_dv_packet {		
	unsigned char	id[4];
	unsigned char	flags[2];
	unsigned char	reserve[2];
	struct	back_bone b_bone;		
	union	dstar_udp {
		struct	dv_buffer dv_buff;
		struct	dv_header rf_header;
		struct	voice_data voice_d;
	};
};

struct	call_table {
	char	req_id[2];
	char	flags[2];
	char	PicVer[2];
	struct	{
		unsigned char : 7;
		unsigned char RepeaterAcc : 1;
	} flag;
	char	reserve;
	char	req_callsign[8];
	char	zone[8];
	char	area[8];
	u_long	ip_address;
	int	ssn;
	int	port;
};

struct	udp_packet{
	union	udp_pkt {
		struct	inet_dv_packet  udp_p;
		struct	call_table	udp_d;
	};
};

		


void	option_set (int argc, char **argv);
void	add_self_node_db (struct sockaddr_in addr);
void	update_self_node_db (struct sockaddr_in addr_db);				
void	print_version(void);
void	print_PICinfo(void);
void	read_from_inet(struct timeval tv);
void	read_from_rig(void);
char	*curtime(void);
void	ctrl_c(void);
void	cfg_read(char file_name[]); 
void	header_print (struct udp_packet r_dv, u_long ip, int sw);
void	voice_packet_print (struct udp_packet r_dv, u_long ip, int sw, int seq);
void	usage(void);
void	Inet_SetUp(void);
void	JitterBufferInit(void);
void	JitterBufferSave(char VoicePacket[], int seq);
void	JitterBufferSend(void);
int	callsign_check(char MyCallsign[]);

/* definition of id in back_bone */
#define	dd_type		0x40
#define	dv_type		0x20
#define	dv_flag		0x21
#define	header_type	0x10