/*************************************************************************
 * PCRaw
 * Author: nori090
 * Original author: ◆e5bW6vDOJ.
 * Copyright: Copyright (C) 2008 nori090
 * Copyright: Copyright (C) 2007 ◆e5bW6vDOJ.
 * Date: February 11, 2007
 * License: 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 * 
 * http://mosax.sakura.ne.jp/fswiki.cgi?page=PCRaw
 */
package org.coderepos.nori090.pcraw;

import java.io.IOException;
import java.nio.channels.SocketChannel;

/**
 * @author nori090
 * @version $Rev: 124 $ $Date: 2008-07-26 23:48:40 +0900 (Sat, 26 Jul 2008) $
 */
public class PCP
    extends StreamIO {
    final static char[] PCP_CONNECT = new char[] { 'p', 'c', 'p', '\n' };

    final static char[] PCP_HELO = new char[] { 'h', 'e', 'l', 'o' };

    final static char[] PCP_OLEH = new char[] { 'o', 'l', 'e', 'h' };

    final static char[] PCP_HELO_SESSIONID = new char[] { 's', 'i', 'd', '\0' };

    final static char[] PCP_HELO_PING = new char[] { 'p', 'i', 'n', 'g' };

    final static char[] PCP_HELO_PORT = new char[] { 'p', 'o', 'r', 't' };

    final static char[] PCP_PCRAW_KEYC = new char[] { 'k', 'e', 'y', 'c' };

    final static char[] PCP_PCRAW_KEYN = new char[] { 'k', 'e', 'y', 'n' };

    final static char[] PCP_PCRAW_KEYP = new char[] { 'k', 'e', 'y', 'p' };

    public PCP( SocketChannel sock ) {
        super.sock = sock;
    }

    static final int MAX_PACKET_SIZE = 1000000;

    Parent readParent()
        throws IOException {
        Parent p = new Parent();
        char[] id = toChar( readExact( 4 ) );
        p.id = id;
        int nc = readInt();
        if ( nc == 0x80000000 ) {
            throw new IOException( "PCP.readParent() Invalid PCP parent." );
        }
        nc &= ~0x80000000;
        p.nc = nc;
        return p;
    }

    void writeParent( Parent p )
        throws IOException {
        int nc = p.nc;
        nc |= 0x80000000;
        writeExact( toByte( p.id ) );
        writeInt( nc );
    }

    Bin readBin()
        throws IOException {
        Bin b = new Bin();
        char[] id = toChar( readExact( 4 ) );
        b.id = id;
        int length = readInt();
        if ( length < 0 || length > MAX_PACKET_SIZE ) {
            throw new IOException( "PCP.readBin() Packet size is too big." );
        }
        b.buf = readExact( length );
        return b;
    }

    void writeBin( Bin b )
        throws IOException {
        writeExact( toByte( b.id ) );
        writeInt( b.buf.length );
        writeExact( b.buf );
    }

    void writeInt( char[] id, int i )
        throws IOException {
        writeExact( toByte( id ) );
        writeInt( 4 );
        writeInt( i );
    }

    void writeInt( char[] id, short i )
        throws IOException {
        writeExact( toByte( id ) );
        writeInt( 2 );
        writeInt( i );
    }

    static class Parent {
        char[] id;

        int nc;
    }

    static class Bin {
        char[] id;

        byte[] buf;
    }

}
