package org.coderepos.nori090.peercast;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;

import org.coderepos.nori090.sen.DatWordLister;
import org.coderepos.nori090.sen.GosenConfig;

import com.enigmastation.classifier.FisherClassifier;
import com.enigmastation.classifier.impl.FisherClassifierImpl;

public class EventChecker {

    public static void main( String[] args ) {
        FisherClassifier fc = new FisherClassifierImpl( new DatWordLister( GosenConfig.getInstance() ) );
        try {
            BufferedReader br =
                new BufferedReader( new InputStreamReader( new FileInputStream( "test.dat" ), "UTF-8" ) );
            String s = null;
            int count = 0;
            while ( ( s = br.readLine() ) != null ) {
                count += 2;
                String ret = br.readLine();
                if ( ret.equals( "@false" ) || ret.equals( "@true" ) ) {
                    fc.train( s, ret );
                }
                else {
                    System.err.println( "miss " + count );
                }
            }
            br.close();

            br = new BufferedReader( new InputStreamReader( new FileInputStream( "test.dat" ), "UTF-8" ) );
            s = null;
            int count_ng = 0;
            int count_ok = 0;
            while ( ( s = br.readLine() ) != null ) {
                String val = s.replaceAll( "<br> ", "\r\n" );
                String ret = br.readLine();
                String result = fc.getClassification( val, null );
                if ( !ret.equals( result ) ) {
                    count_ng++;
                    System.out.println( String.format( "NG! i want %s but was %s", ret, result ) );
                    // System.out.println( String.format( "NG! i want %s but was %s : %s", ret, result, val ) );
                }
                else {
                    count_ok++;
                    System.out.println( String.format( "OK! %s", ret ) );
                    // System.out.println( String.format( "OK! %s : %s", ret, val ) );
                }
            }
            System.out.println( String.format( "正確さ： OK[%d], NG[%d] 正答率[%d]", count_ok, count_ng,
                                               ( ( count_ok * 100 ) / ( count_ok + count_ng ) ) ) );
            br.close();
        }
        catch ( Exception e ) {
            e.printStackTrace();
        }

    }
}
