package org.coderepos.nori090.peercast;

import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;

import org.apache.commons.io.IOUtils;

public class EventCollectorUtil {

    private EventCollectorUtil() {
    }

    static ConcurrentHashMap<String, String> cache = new ConcurrentHashMap<String, String>();

    static long thread_count = 0;

    public static String getEventRssStream( final String str_url ) {
        Runnable run = new Runnable() {

            @Override
            public void run() {
                URL url;
                HttpURLConnection con = null;
                InputStreamReader isr = null;
                try {
                    url = new URL( str_url );
                    con = (HttpURLConnection) url.openConnection();
                    isr = new InputStreamReader( con.getInputStream(), "UTF-8" );
                    char[] cs = new char[1024];
                    int size = -1;
                    StringBuilder sb = new StringBuilder();
                    while ( ( size = isr.read( cs, 0, cs.length ) ) != -1 ) {
                        for ( int i = 0; i < size; i++ ) {
                            cs[i] = euc2unicode( cs[i] );
                        }
                        sb.append( cs, 0, size );
                    }
                    cache.put( str_url,
                               sb.toString().replaceAll( "http://my.netscape.com/publish/formats/rss-0.91.dtd",
                                                         "http://www.rssboard.org/rss-0.91.dtd" ) );
                }
                catch ( Exception e ) {
                    e.printStackTrace();
                }
                finally {
                    if ( con != null ) {
                        con.disconnect();
                    }
                    IOUtils.closeQuietly( isr );
                }
            }
        };
        thread_count++;
        new Thread( run, "EventCollector$getEventRssStream" + thread_count ).start();
        return cache.get( str_url );
    }

    static char euc2unicode( char c ) {
        // http://docs.hp.com/ja/5187-0702/ch09s05.html
        if ( c == '\u203e' )
            return '\uffe3';
        if ( c == '\u00a5' )
            return '\uffe5';
        if ( c == '\u2014' )
            return '\u2015';
        if ( c == '\u301c' )
            return '\uff5e';
        if ( c == '\u2016' )
            return '\u2225';
        if ( c == '\u2212' )
            return '\uff0d';
        if ( c == '\u00a2' )
            return '\uffe0';
        if ( c == '\u00a3' )
            return '\uffe1';
        if ( c == '\u00ac' )
            return '\uffe2';
        if ( c == '\u00a6' )
            return '\uffe4';
        return c;
    }

    static String unicode2sjis0201( String s ) {
        if ( s != null ) {
            return unicode2sjis0201( s.toCharArray() );
        }
        return null;
    }

    static String unicode2sjis0201( char... cs ) {
        StringBuilder sb = new StringBuilder();
        if ( cs != null ) {
            for ( char c : cs ) {
                if ( c == '\uffe3' )
                    sb.append( '\uffe3' );
                if ( c == '\uffe5' )
                    sb.append( '\uffe5' );
                if ( c == '\u2015' )
                    sb.append( '\u2014' );
                if ( c == '\uff5e' )
                    sb.append( '\u301c' );
                if ( c == '\u2225' )
                    sb.append( '\u2016' );
                if ( c == '\uff0d' )
                    sb.append( '\u2212' );
                if ( c == '\uffe0' )
                    sb.append( '\u00a2' );
                if ( c == '\uffe1' )
                    sb.append( '\u00a3' );
                if ( c == '\uffe2' )
                    sb.append( '\u00ac' );
                sb.append( c );
            }
        }
        return sb.toString();
    }

    public static void main( String[] args ) {
        getEventRssStream( "http://listeners.peca.jp/?cmd=rssevent" );
    }
}
