/*
 * Copyright 2007 nori090
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jimmy.command;

import jimmy.ConvertUtil;

import org.apache.commons.codec.binary.Hex;

import junit.framework.TestCase;

/**
 * command01 test
 * 
 * @author nori090
 * @version $Rev: 17 $ $Date: 2008-03-25 22:45:24 +0900 (Tue, 25 Mar 2008) $
 */
public class Command01Test
    extends TestCase {
    public void test_unpack() {
        try {
            Command c = Command.getCommandInstance( Hex.decodeHex( "05000000010000f042".toCharArray() ) );
            if ( c instanceof Command01 ) {
                Command01 c01 = (Command01) c;
                assertEquals( ConvertUtil.littleEndianBytes2int( Hex.decodeHex( "0000f042".toCharArray() ) ),
                              Float.floatToIntBits( c01.speed ) );
                assertEquals( 5, c01.block_length );
            }
            else {
                fail();
            }
        }
        catch ( Exception e ) {
            e.printStackTrace();
            fail();
        }
    }

    public void test_pack() {
        try {
            Command01 c01 = new Command01();
            c01.speed = (float)120.0;
            byte[] packed = c01.pack();
            String packstring = String.valueOf( Hex.encodeHex( packed ) );
            assertEquals( "05000000010000f042", packstring );
        }
        catch ( Exception e ) {
            e.printStackTrace();
            fail();
        }
    }
}
