package jimmy.command;

import junit.framework.TestCase;

import org.apache.commons.codec.binary.Hex;

/*
 * Copyright 2007 nori090
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * command10 test
 * @author nori090
 * @version $Rev: 17 $ $Date: 2008-03-25 22:45:24 +0900 (Tue, 25 Mar 2008) $
 */
public class Command10Test
    extends TestCase {
    public void test_unpack() {
        try {
            Command c = Command.getCommandInstance( Hex.decodeHex( "010000000a".toCharArray() ) );
            if ( c instanceof Command10 ) {
                Command10 c10 = (Command10) c;
                String pak = String.valueOf( Hex.encodeHex( c10.pack() ) );
                assertEquals( "010000000a", pak );
            }
            else {
                fail();
            }
        }
        catch ( Exception e ) {
            e.printStackTrace();
            fail();
        }
    }

    public void test_pack() {
        try {
            Command10 c10 = new Command10();
            System.out.println( Hex.encodeHex( c10.pack() ) );
        }
        catch ( Exception e ) {
            e.printStackTrace();
            fail();
        }
    }
}
