/*
 * Copyright 2007 nori090
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package lib2chj;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import lib2chj.struct.Category;
import lib2chj.struct.Comment;
import lib2chj.struct.HTTP_DATA;
import lib2chj.struct.Ita;
import lib2chj.struct.Server;
import lib2chj.struct.Subject;
import lib2chj.struct.Thread;
import lib2chj.util.BbsMenu;
import lib2chj.util.SubjectBuilder;
import lib2chj.util.ThreadBuilder;

/**
 * @author nori090
 * @version $Rev: 19 $ $Date: 2008-03-25 22:46:11 +0900 (Tue, 25 Mar 2008) $
 */
public class HttpGet2ch {
    HTTP_DATA _http_data;

    Map<String, Server> _map2ch;

    Object target;

    public static void main( String[] args )
        throws IOException {
        // subject_sample();
         thread_sample();
        //bbsmenu_sample();
    }

    static void bbsmenu_sample() {
        Set<Category> set = BbsMenu.getCategorys();
        for ( Category c : set ) {
            System.out.println( c.getCategory() );
            for ( Iterator<String> ite = c.getItaMap().keySet().iterator(); ite.hasNext(); ) {
                String key = ite.next();
                Ita ita = c.getIta( key );
                System.out.println( "\t" + ita.getItaName_ja() + "\n\t\t" + ita.getUrl() );
            }
        }
    }

    static void subject_sample()
        throws IOException {
        System.out.println( "subject:" );
        int count = 0;
        Map<String, Server> map = new SubjectBuilder().get( "http://pc11.2ch.net/tech/subject.txt" ).toMap();
        for ( Iterator<String> iterator = map.keySet().iterator(); iterator.hasNext(); ) {
            String key = iterator.next();
            Server s = map.get( key );
            for ( Iterator<String> iterator2 = s.getItaMap().keySet().iterator(); iterator2.hasNext(); ) {
                String key2 = iterator2.next();
                Ita ita = s.getIta( key2 );
                for ( Iterator<String> iterator3 = ita.getSubjects().keySet().iterator(); iterator3.hasNext(); ) {
                    String key3 = iterator3.next();
                    Subject subject = ita.getSubject( key3 );
                    String url = subject.getUrl();
                    System.out.printf( "%d:\t%s\n\t%s (%d)\n\n", ++count, url, subject.getTitle(),
                                       subject.getCommentCount() );
                }
            }
        }
    }

    static void thread_sample()
        throws IOException {
        // http://pc11.2ch.net/test/read.cgi/tech/1057329161/
        // http://pc11.2ch.net/tech/dat/1057329161.dat
        HTTP_DATA data = new HTTP_DATA();
        data.setContent_length( -1 );
        // http://news21.2ch.net/test/read.cgi/bizplus/1196683840/l50
        // data.setUrl( "http://news21.2ch.net/bizplus/dat/1196683840.dat" );
        data.setUrl( "http://pc11.2ch.net/tech/dat/1057329161.dat" );
        // data.setUrl( "http://pc11.2ch.net/tech/subject.txt" );
        // data.setEtag( "\"4a099c-2ea2f-5a7ef780\"" );

        Map<String, Server> m = new ThreadBuilder().get( data.getUrl() ).toMap();
        int count = 0;
        for ( Iterator<String> iterator = m.keySet().iterator(); iterator.hasNext(); ) {
            String key = iterator.next();
            Server s = m.get( key );
            for ( Iterator<String> iterator2 = s.getItaMap().keySet().iterator(); iterator2.hasNext(); ) {
                String key2 = iterator2.next();
                Ita ita = s.getIta( key2 );
                for ( Iterator<String> iterator3 = ita.getThreads().keySet().iterator(); iterator3.hasNext(); ) {
                    String key3 = iterator3.next();
                    Thread thread = ita.getThread( key3 );
                    String url = thread.getUrl();
                    System.out.printf( "%d:\n\t%s\n\t%s (%d)\n", ++count, url, thread.getTitle(),
                                       thread.getSubject().getCommentCount() );
                    for ( Comment com : thread.getComments() ) {
                        System.out.println( com.toString_d() );
                    }
                }
            }
        }
        System.out.println();
    }
}
