/*
 * Copyright 2007 nori090
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package lib2chj.struct;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 
 * @author nori090
 * @version $Rev:3452 $ $Date:2007-12-22 15:11:38 +0000 (土, 22 12 2007) $
 */
public class Subject {
    // 所属板
    Ita ita;

    // １スレッドの現在のレス数
    int count;

    // １スレッドタイトル
    String title;

    // １スレッドurl
    String url;

    // １スレッド
    Thread thread;

    // １スレッドID
    String id;

    // constructor
    public Subject( Ita ita ) {
        super();
        this.ita = ita;
    }

    // getter and setter
    public Thread getThread() {
        return thread;
    }

    public Ita getIta() {
        return ita;
    }

    public Subject setThread( Thread thread ) {
        this.thread = thread;
        return this;
    }

    public int getCommentCount() {
        return count;
    }

    public Subject setCommentCount( int count ) {
        this.count = count;
        return this;
    }

    public String getTitle() {
        return title;
    }

    public Subject setTitle( String title ) {
        this.title = title;
        return this;
    }

    public String getUrl() {
        return url;
    }

    public Subject setUrl( String url ) {
        this.url = url;
        return this;
    }

    public String getId() {
        return id;
    }

    public Subject setId( String id ) {
        this.id = id;
        return this;
    }

    public String toString_d() {
        return new ToStringBuilder( this ).append( "ita", ita ).append( "id", id ).append( "count", count ).append(
                                                                                                                    "title",
                                                                                                                    title ).append(
                                                                                                                                    "url",
                                                                                                                                    url ).append(
                                                                                                                                                  "thread",
                                                                                                                                                  thread ).toString();
    }

    public String view() {
        return getTitle()+"("+getCommentCount()+")";
    }
    
}
