/*
 * Copyright 2007 nori090
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package lib2chj.util;

import lib2chj.struct.Ita;
import lib2chj.struct.Server;
import lib2chj.struct.Thread;

/**
 * @author nori090
 * @version $Rev:3452 $ $Date:2007-12-22 15:11:38 +0000 (土, 22 12 2007) $
 */
public class ParseUtil {
    /**
     * in = デフォルトの名無しさん<><>03/07/04 23:33<> 削除依頼よろしく <> <br>
     * out = {デフォルトの名無しさん,,03/07/04 23:33, 削除依頼よろしく } as String[]<br>
     */
    static String[] split_comment( String line ) {
        return line.split( "<>" );
    }

    /**
     * in = 2007/12/03(月) 21:20:29 ID:oqamS9Td<br>
     * out = {2007/12/03(月) 21:20:29,ID:oqamS9Td} as String[]
     */
    static String[] split_date_id( String line ) {
        int index = -1;
        if ( ( index = line.indexOf( "ID:" ) ) != -1 )
            return new String[] { line.substring( 0, index - 1 ), line.substring( index ) };
        else
            return new String[] { line };
    }

    /**
     * subject.txtの１行を分割する。 <br>
     * 例) <br>
     * in = 1057329161.dat<>monazilla Part 5 (828) <br>
     * out = {1057329161.dat,monazilla Part 5,828} <br>
     * <br>
     * in = datファイル名<>スレタイ(レス数) <br>
     * out = {datファイル名,スレタイ,レス数} as String[]
     */
    static String[] split_subject( String line ) {
        String[] s = line.split( "<>" );
        return new String[] { s[0], s[1].substring( 0, s[1].lastIndexOf( '(' ) - 1 ),
            s[1].substring( ( s[1].lastIndexOf( '(' ) + 1 ), ( s[1].length() - 1 ) ) };
    }

    /**
     * read.cgi用のurlを作る
     */
    public static String make_read_cgi_url( Thread thread ) {
        Ita ita = thread.getIta();
        Server serv = ita.getServer();
        return "http://" + serv.getServerName() + "/test/read.cgi/" + ita.getItaName() + "/" + thread.getId();
    }

    /**
     * 名前にコテが含まれる場合のBold Tag表現を正常に戻す。<br>
     * 例) ウンコ ＜/b＞◆PNECKYQmKE＜b＞
     */
    public static String reverseBoldTag( String s ) {
        s = s.replaceAll( "</b>", "<b>" );
        if ( s.endsWith( "<b>" ) ) {
            String tmp = s.substring( 0, s.lastIndexOf( "<b>" ) ) + "</b>";
            return tmp;
        }
        else {
            return s;
        }
    }
}
