package lib2chj.util;

import junit.framework.TestCase;
import junitx.framework.ArrayAssert;

/*
 * Copyright 2007 nori090
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @author nori090
 * @version $Rev: 19 $ $Date: 2008-03-25 22:46:11 +0900 (Tue, 25 Mar 2008) $
 */
public class HttpHelperTest
    extends TestCase {

    public void test_split_thread_id_at_path1() {
        String r = HttpHelper._split_thread_id_at_path( "/hogehoge/dat/1234567890.dat" );
        assertEquals( "1234567890", r );
    }

    public void test_split_thread_id_at_path2() {
        String r = HttpHelper._split_thread_id_at_path( "hogehoge/dat/1234567890.dat" );
        assertEquals( "1234567890", r );
    }
    
    public void test_split_ita_name_at_path1() {
        String r = HttpHelper._split_ita_name_at_path( "/hogehoge/dat/1234567890.dat" );
        assertEquals( "hogehoge", r );
    }

    public void test_split_ita_name_at_path2() {
        String r = HttpHelper._split_ita_name_at_path( "hogehoge/dat/1234567890.dat" );
        assertEquals( "hogehoge", r );
    }

    public void test_kako_log_id10() {
        String[] r = HttpHelper._kako_log_id10( "server", "itadesu", "1234567890" );
        String[] m =
            new String[] { 
                "http://server/itadesu/kako/1234/12345/1234567890.dat.gz",
                "http://server/itadesu/kako/1234/12345/1234567890.dat" };
        ArrayAssert.assertEquals( m, r );
    }

    public void test_kako_log_id9() {
        String[] r = HttpHelper._kako_log_id9( "server", "itadesu", "123456789" );
        String[] m =
            new String[] { 
                "http://server/itadesu/kako/123/123456789.dat.gz",
                "http://server/itadesu/kako/123/123456789.dat" };
        ArrayAssert.assertEquals( m, r );
    }
}
