/*
 * Copyright 2008 nori090
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.coderepos.nori090.lib2chj;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

/**
 * @author nori090
 * @version $Rev: 85 $ $Date: 2008-06-02 22:18:54 +0900 (Mon, 02 Jun 2008) $
 */
public class CategoryImpl
    implements Category {
    private HashMap<String, String> self = new HashMap<String, String>();

    private LinkedHashMap<String, Ita> v1 = new LinkedHashMap<String, Ita>();

    private LinkedHashMap<String, Ita> v2 = new LinkedHashMap<String, Ita>();

    @Override
    public Category addIta( Ita ita ) {
        Ita old = v1.get( ita.getItaName() );
        if ( old == null ) {
            v1.put( ita.getItaName(), ita );
            v2.put( ita.getItaName_ja(), ita );
        }
        else {
            old.setItaName( ita.getItaName() );
            old.setItaName_ja( ita.getItaName_ja() );
            old.setSubjects( ita.getSubjects() );
            old.setThreads( ita.getThreads() );
            old.setUrl( ita.getUrl() );
        }
        return this;
    }

    @Override
    public String getCategory() {
        return self.get( "category" );
    }

    @Override
    public Ita getIta( String key ) {
        Ita ita = v1.get( key );
        return ita != null ? ita : v2.get( key );
    }

    @Override
    public List<Ita> getItaList() {
        ArrayList<Ita> list = new ArrayList<Ita>();
        for ( Ita ita : v1.values() ) {
            list.add( ita );
        }
        return list;
    }

    @Override
    public Category setCategory( String category ) {
        self.put( "category", category );
        return this;
    }

    @Override
    public Category addItaList( List<Ita> itaList ) {
        for ( Ita ita : itaList ) {
            addIta( ita );
        }
        return this;
    }

}
