/*
 * Copyright 2008 nori090
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.coderepos.nori090.lib2chj;

import java.util.HashMap;

/**
 * @author nori090
 * @version $Rev: 85 $ $Date: 2008-06-02 22:18:54 +0900 (Mon, 02 Jun 2008) $
 */
public class CommentImpl
    implements Comment {

    private HashMap<String, Object> v = new HashMap<String, Object>();

    @Override
    public String getBody() {
        return (String) v.get( "body" );
    }

    @Override
    public String getDate() {
        return (String) v.get( "date" );
    }

    @Override
    public String getId() {
        return (String) v.get( "id" );
    }

    @Override
    public String getMailto() {
        return (String) v.get( "mailto" );
    }

    @Override
    public String getName() {
        return (String) v.get( "name" );
    }

    @Override
    public int getNumberOfCount() {
        String s = (String) v.get( "count" );
        if ( s == null ) {
            v.put( "count", "-1" );
            return -1;
        }
        return Integer.parseInt( s );
    }

    @Override
    public Thread getThread() {
        return (Thread) v.get( "thread" );
    }

    @Override
    public Comment setThread( Thread thread ) {
        v.put( "thread", thread );
        return this;
    }

    @Override
    public Comment setBody( String body ) {
        v.put( "body", body );
        return this;
    }

    @Override
    public Comment setDate( String date ) {
        v.put( "date", date );
        return this;
    }

    @Override
    public Comment setId( String id ) {
        v.put( "id", id );
        return this;
    }

    @Override
    public Comment setMailto( String mailto ) {
        v.put( "mailto", mailto );
        return this;
    }

    @Override
    public Comment setName( String name ) {
        v.put( "name", name );
        return this;
    }

    @Override
    public Comment setNumberOfCount( int num ) {
        v.put( "count", String.valueOf( num ) );
        return this;
    }

}
