/*
 * Copyright 2008 nori090
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.coderepos.nori090.lib2chj;

/**
 * @author nori090
 * @version $Rev: 85 $ $Date: 2008-06-02 22:18:54 +0900 (Mon, 02 Jun 2008) $
 */
public class ThreadAverage {
    // Nヶ月
    private long month;

    // N日
    private long date;

    // N時間
    private long hour;

    // N分
    private long minutes;

    // 剰余（秒）
    private long residue;

    private ThreadAverage() {
        super();
    }

    public static ThreadAverage getAverage( Subject subject ) {
        ThreadAverage ave = new ThreadAverage();
        long l = ( subject.getLastUpdate().getTime() - subject.getThreadBuildDate().getTime() ) / 1000;
        long l2 = l / subject.getCommentCount();
        if ( ( 60 * 60 * 24 * 30 ) <= l2 ) {
            ave.month = l2 / ( 60 * 60 * 24 * 30 );
            l2 = l2 % ( 60 * 60 * 24 * 30 );
        }
        if ( ( 60 * 60 * 24 ) <= l2 ) {
            ave.date = l2 / ( 60 * 60 * 24 );
            l2 = l2 % ( 60 * 60 * 24 );
        }
        if ( ( 60 * 60 ) <= l2 ) {
            ave.hour = l2 / ( 60 * 60 );
            l2 = l2 % ( 60 * 60 );
        }
        if ( 60 <= l2 ) {
            ave.minutes = l2 / 60;
            l2 = l2 % 60;
        }
        ave.residue = l2;
        return ave;
    }

    public long getMonth() {
        return month;
    }

    public long getDate() {
        return date;
    }

    public long getHour() {
        return hour;
    }

    public long getMinutes() {
        return minutes;
    }

    public long getResidue() {
        return residue;
    }

}
