﻿/*
 * Copyright (c) 2006 Ichro Maruta
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 * */

var modic_search = {
  init: false,
  db_service: null,
  lookup_statement: null,
  last: null,

  initialize: function() {
    this.db_service = Components.classes["@nori090.org/english/sqlite-service;1"].getService(Components.interfaces.modicIEnglishDB);
    this.lookup_statement = this.db_service.createStatement("SELECT * FROM dict WHERE key = ?1 ORDER BY key asc");
  },

  do: function(e) {
    if(!this.init) {this.initialize();this.init=true;}
    var sidebar = top.document.getElementById("sidebar");
    var result = sidebar.contentDocument.getElementById("result");
    var q = sidebar.contentDocument.getElementById("modic-query").value;
    if (/^[a-zA-Z -]{2,}$/.test(q)) {
      q = q.trim().replace(/[ ]{2,}/g, " ");
      if (this.last == q) return;
      this.last = q;
      var ret = this.s(q);
    }
  },
  
  s: function(w) {
    var r = this.lookupDB(w);
    var d = (r == undefined) ? this.no_match(w): this.match(r);
    var format = '<style type=text/css>div.key{color:#000088;font-weight:bold;}div.error{color:red;font-weight:bold;}div.desc{font-size:small;}span.annote{color:green;}span.ex{color:orange;}</style>';
    format+=d;
    format+='</font>';
    var doc = top.document.getElementById("sidebar").contentDocument.getElementById("result").contentDocument;
    doc.open();
    doc.write(format);
    doc.close();
  },
  
  no_match: function(w) {
    var data = '<div class="key">' + w + '</div>';
    data += '<div class="error">No match in dictionary.</div>';
    return data;
  },
  
  match: function(w) {
    var ret = '<div class="key">' + w.word + '</div><div class="desc">';
    var dat = w.data.replace(/・[a-zA-Z].+?(\\ |$)/gm, '');
    dat = dat.replace(/◆(.+?)\\ /gm, '<span class="annote">◆$1\\ </span>');
    dat = dat.replace(/【＠】.*$/gm, '');
    dat = dat.replace(/\\ /g, '<br>');
    return ret + dat + '</div>';
  },

  lookupDB: function(w) {
    var data;
    try {
      this.lookup_statement.bindUTF8StringParameter(0, w);
      while(this.lookup_statement.executeStep()) {
        data = {word:this.lookup_statement.getString(0), data:this.lookup_statement.getString(1)};
      }
    } catch(err) {
      alert(err);
    } finally {
      this.lookup_statement.reset();
    }
    return data;
  },

}

var modic_search_j = {
  init: false,
  db_service: null,
  lookup_statement: null,
  last: null,

  initialize: function() {
    this.db_service = Components.classes["@nori090.org/japanese/sqlite-service;1"].getService(Components.interfaces.modicIJapaneseDB);
    this.lookup_statement = this.db_service.createStatement("SELECT * FROM dict WHERE key = ?1 ORDER BY key asc");
  },

  do: function(e) {
    if(!this.init) {this.initialize();this.init=true;}
    var sidebar = top.document.getElementById("sidebar");
    var result = sidebar.contentDocument.getElementById("result");
    var q = sidebar.contentDocument.getElementById("modic-query-j").value;
    if (/^.{2,}$/.test(q)) {
      q = q.trim().replace(/[ ]{2,}/g, " ");
      if (this.last == q) return;
      this.last = q;
      var ret = this.s(q);
    }
  },
  
  s: function(w) {
    var r = this.lookupDB(w);
    var d = (r == undefined) ? this.no_match(w): this.match(r);
    var format = '<style type=text/css>div.key{color:#000088;font-weight:bold;}div.error{color:red;font-weight:bold;}div.desc{font-size:small;}span.annote{color:green;}span.ex{color:orange;}</style>';
    format+=d;
    format+='</font>';
    var doc = top.document.getElementById("sidebar").contentDocument.getElementById("result").contentDocument;
    doc.open();
    doc.write(format);
    doc.close();
  },
  
  no_match: function(w) {
    var data = '<div class="key">' + w + '</div>';
    data += '<div class="error">No match in dictionary.</div>';
    return data;
  },
  
  log: Components.classes["@mozilla.org/consoleservice;1"].getService(Components.interfaces.nsIConsoleService),

  match: function(w) {
    //this.log.logStringMessage(w.data);
    var ret = '<div class="key">' + w.word + '</div><div class="desc">';
    var dat = w.data;//.replace(/・[a-zA-Z].+?(\\ |$)/gm, '');
    //dat = dat.replace(/◆(.+?)\\ /gm, '<span class="annote">◆$1\\ </span>');
    //dat = dat.replace(/【＠】.*$/gm, '');
    dat = dat.replace(/●/g, '<br>');
    return ret + dat + '</div>';
  },

  lookupDB: function(w) {
    var data;
    try {
      this.lookup_statement.bindUTF8StringParameter(0, w);
      while(this.lookup_statement.executeStep()) {
        data = {word:this.lookup_statement.getString(0), data:this.lookup_statement.getString(1)};
      }
    } catch(err) {
      alert(err);
    } finally {
      this.lookup_statement.reset();
    }
    return data;
  },

}


function font_announce() {
  var prefs = Components.classes["@mozilla.org/preferences-service;1"].
  getService(Components.interfaces.nsIPrefBranch);
  var sidebar = top.document.getElementById("sidebar");
  var result = sidebar.contentDocument.getElementById("result");
  var doc = result.contentDocument;
  doc.open();
  doc.write('<style type=text/css>div.key{color:#000088;font-weight:bold;}div.error{color:red;font-weight:bold;}div.desc{font-size:small;}span.annote{color:green;}span.ex{color:orange;}</style>');
  var fontsize = prefs.getIntPref("extensions.mouseoverdictionary.sidebar_font_size");
  if (fontsize < 0) {
    fontsize = fontsize + "";
  } else {
    fontsize = "+" + fontsize;
  }
  doc.write('<font size=' + fontsize + '>');
  doc.write('<div class="key">font size has changed.</div>');
  doc.write('<div class="error">フォントサイズが変更されました。</div>');
  doc.write('</font>');
  doc.close();

}

function font_enlarge() {
  var prefs = Components.classes["@mozilla.org/preferences-service;1"].
  getService(Components.interfaces.nsIPrefBranch);
  var fontsize = prefs.getIntPref("extensions.mouseoverdictionary.sidebar_font_size");
  prefs.setIntPref("extensions.mouseoverdictionary.sidebar_font_size", fontsize + 1);
  font_announce();
}

function font_reduce() {
  var prefs = Components.classes["@mozilla.org/preferences-service;1"].
  getService(Components.interfaces.nsIPrefBranch);
  var fontsize = prefs.getIntPref("extensions.mouseoverdictionary.sidebar_font_size");
  prefs.setIntPref("extensions.mouseoverdictionary.sidebar_font_size", fontsize - 1);
  font_announce();
}

function font_normal() {
  var prefs = Components.classes["@mozilla.org/preferences-service;1"].
  getService(Components.interfaces.nsIPrefBranch);
  prefs.setIntPref("extensions.mouseoverdictionary.sidebar_font_size", 0);
  font_announce();
}
