package peca;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

/**
 *
 * @author nori090
 */
public class ChannelTable extends AbstractTableModel {

    List<String> fav;
    ChannelData[] data;
    List<String> head;
    List<String[]> filtered_data;
    RowColorSetting[] keywords;

    public ChannelTable(List<String> fav, ChannelData[] data, RowColorSetting... keywords) {
        this.fav = fav;
        this.data = data;
        this.keywords = (keywords);
        init();
    }

    void init() {
        head = new ArrayList<String>();
        for (String s : fav) {
            if (s.startsWith("[")) {
                head.add(s.split(",")[0]);
            } else {
                head.add(s);
            }
        }
        filtered_data = new ArrayList<String[]>();
        Map<String, String[]> tenkai = new HashMap<String, String[]>();
        for (ChannelData d : data) {
            String[] sdata = new String[head.size()];
            for (int i = 0; i < head.size(); i++) {
                String h = head.get(i);
                String str = d.get(h);
                if (str == null) {
                    str = "";
                    if (tenkai.get(h) == null) {
                        String target = "";
                        for (String fav_str : this.fav) {
                            if (fav_str.startsWith(h)) {
                                target = fav_str;
                                break;
                            }
                        }
                        String[] split = target.split(",");
                        String[] sub = new String[split.length - 1];
                        for (int j = 0; j < sub.length; j++) {
                            sub[j] = split[j + 1];
                        }
                        tenkai.put(h, sub);
                    }
                    String[] tenkai_hs = tenkai.get(h);
                    StringBuffer sb = new StringBuffer();
                    for (String tenkai_h : tenkai_hs) {
                        if (!"".equals(d.get(tenkai_h))) {
                            sb.append(d.get(tenkai_h)).append(" - ");
                        }
                    }
                    if (sb.lastIndexOf(" - ") + 3 == sb.length()) {
                        sb.delete(sb.length() - 3, sb.length());
                    }
                    str = sb.toString();
                }
                sdata[i] = str;
            }
            filtered_data.add(sdata);
        }
    }

    @Override
    public String getColumnName(int column) {
        return head.get(column);
    }

    public int getRowCount() {
        return filtered_data.size();
    }

    public int getColumnCount() {
        return head.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return filtered_data.get(rowIndex)[columnIndex];
    }

//    final Comparator<ChannelData> sorter = new Comparator<ChannelData>() {
//
//        public int compare(ChannelData o1, ChannelData o2) {
//            Integer i1 = _num(o1.get(8));
//            Integer i2 = _num(o2.get(8));
//            int ret = i2.compareTo(i1);
//            if (ret == 0) {
//                ret = o1.get(0).compareTo(o2.get(0));
//            }
//            return ret;
//        }
//    };
//
//    private Integer _num(String s) {
//        try {
//            return Integer.valueOf(s);
//        } catch (Exception e) {
//            return Integer.valueOf(-1);
//        }
//    }
//                @Override
//            public int getRowCount() {
//                return buildChannelDataTableThread.get().length;
//            }
//
//            @Override
//            public Object getValueAt(int rowIndex, int columnIndex) {
//                if (super.fav != null) {
//                    columnIndex = fav_pos_2_fix_pos(columnIndex);
//                }
//                return buildChannelDataTableThread.get()[rowIndex].get(columnIndex);
//            }
}
