/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package peercast4j.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * 
 * @author nori090
 */
public class BuildChannelDataTableThread extends Thread {

    private URL[] urls;
    private ChannelData[] channeldata;

    public BuildChannelDataTableThread(URL[] urls) {
        this.urls = urls;
    }

    @Override
    public void run() {
        ArrayList<ChannelData> list = new ArrayList<ChannelData>();
        for (URL url : urls) {
            try {
                HttpURLConnection con = (HttpURLConnection) url.openConnection();
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream) con.getContent(), "UTF-8"));
                String s = null;
                while ((s = br.readLine()) != null) {
                    list.add(new ChannelData(s));
                }
            } catch (IOException ex) {
                Logger.getLogger(BuildChannelDataTableThread.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        channeldata = list.toArray(new ChannelData[]{});
    }

    public ChannelData[] get() {
        return channeldata;
    }

    public static void main(String[] args) {
        try {
            BuildChannelDataTableThread a = new BuildChannelDataTableThread(new URL[]{new URL("http://localhost:8080/http://extremeyp.ath.cx/index.txt")});
            a.run();
            for (ChannelData d : a.get()) {
                System.out.println(d);
            }
        } catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
    }
}
