// (c) 2008 Taku Kudo <taku@chasen.org>
// TinySegmenter is freely distributable under the terms of a new BSD licence.
// For details, see http://chasen.org/~taku/software/TinySegmenter/LICENCE.txt

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * http://chasen.org/~taku/software/TinySegmenter/tiny_segmenter-0.1.js
 * 
 * @author nori090
 * 
 */
@SuppressWarnings("serial")
public class TinySegmenter {

	public static void main(String[] args) {
		TinySegmenter t = new TinySegmenter();
		List<String> r = t.segment("私の名前は中野です");
		for (String s : r) {
			System.out.println(s);
		}
	}

	private HashMap<String, String> patterns = new HashMap<String, String>() {
		{
			put("[一二三四五六七八九十百千万億兆]", "M");
			put("[一-龠々〆ヵヶ]", "H");
			put("[ぁ-ん]", "I");
			put("[ァ-ヴーｱ-ﾝﾞｰ]", "K");
			put("[a-zA-Zａ-ｚＡ-Ｚ]", "A");
			put("[0-9０-９]", "N");
		}
	};
	private LinkedHashMap<Pattern, String> chartype_ = new LinkedHashMap<Pattern, String>();
	private int BIAS__ = -332;

	public TinySegmenter() {
		for (String s : patterns.keySet()) {
			Pattern p = Pattern.compile(s);
			chartype_.put(p, patterns.get(s));
		}
	}

	private String ctype_(String s) {
		for (Pattern p : chartype_.keySet()) {
			Matcher m = p.matcher(s);
			if (m.find())
				return chartype_.get(p);
		}
		return "O";
	}

	private int ts_(Integer v) {
		if (v != null)
			return v.intValue();
		return 0;
	}

	public ArrayList<String> segment(String value) {
		ArrayList<String> result = new ArrayList<String>();
		List<String> seg = new ArrayList<String>() {
			{
				add("B3");
				add("B2");
				add("B1");
			}
		};
		List<String> ctype = new ArrayList<String>() {
			{
				add("O");
				add("O");
				add("O");
			}
		};
		char[] o = value.toCharArray();
		for (int i = 0; i < o.length; i++) {
			String tmp = Character.toString(o[i]);
			seg.add(tmp);
			ctype.add(ctype_(tmp));
		}
		seg.add("E1");
		seg.add("E2");
		seg.add("E3");
		ctype.add("O");
		ctype.add("O");
		ctype.add("O");
		StringBuilder word = new StringBuilder().append(seg.get(3));
		String p1 = "U";
		String p2 = "U";
		String p3 = "U";

		for (int i = 4; i < seg.size() - 3; ++i) {
			int score = this.BIAS__;
			String w1 = seg.get(i - 3);
			String w2 = seg.get(i - 2);
			String w3 = seg.get(i - 1);
			String w4 = seg.get(i);
			String w5 = seg.get(i + 1);
			String w6 = seg.get(i + 2);
			String c1 = ctype.get(i - 3);
			String c2 = ctype.get(i - 2);
			String c3 = ctype.get(i - 1);
			String c4 = ctype.get(i);
			String c5 = ctype.get(i + 1);
			String c6 = ctype.get(i + 2);
			score += this.ts_(this.UP1__.get(p1));
			score += this.ts_(this.UP2__.get(p2));
			score += this.ts_(this.UP3__.get(p3));
			score += this.ts_(this.BP1__.get(p1 + p2));
			score += this.ts_(this.BP2__.get(p2 + p3));
			score += this.ts_(this.UW1__.get(w1));
			score += this.ts_(this.UW2__.get(w2));
			score += this.ts_(this.UW3__.get(w3));
			score += this.ts_(this.UW4__.get(w4));
			score += this.ts_(this.UW5__.get(w5));
			score += this.ts_(this.UW6__.get(w6));
			score += this.ts_(this.BW1__.get(w2 + w3));
			score += this.ts_(this.BW2__.get(w3 + w4));
			score += this.ts_(this.BW3__.get(w4 + w5));
			score += this.ts_(this.TW1__.get(w1 + w2 + w3));
			score += this.ts_(this.TW2__.get(w2 + w3 + w4));
			score += this.ts_(this.TW3__.get(w3 + w4 + w5));
			score += this.ts_(this.TW4__.get(w4 + w5 + w6));
			score += this.ts_(this.UC1__.get(c1));
			score += this.ts_(this.UC2__.get(c2));
			score += this.ts_(this.UC3__.get(c3));
			score += this.ts_(this.UC4__.get(c4));
			score += this.ts_(this.UC5__.get(c5));
			score += this.ts_(this.UC6__.get(c6));
			score += this.ts_(this.BC1__.get(c2 + c3));
			score += this.ts_(this.BC2__.get(c3 + c4));
			score += this.ts_(this.BC3__.get(c4 + c5));
			score += this.ts_(this.TC1__.get(c1 + c2 + c3));
			score += this.ts_(this.TC2__.get(c2 + c3 + c4));
			score += this.ts_(this.TC3__.get(c3 + c4 + c5));
			score += this.ts_(this.TC4__.get(c4 + c5 + c6));
			score += this.ts_(this.UQ1__.get(p1 + c1));
			score += this.ts_(this.UQ2__.get(p2 + c2));
			score += this.ts_(this.UQ1__.get(p3 + c3));
			score += this.ts_(this.BQ1__.get(p2 + c2 + c3));
			score += this.ts_(this.BQ2__.get(p2 + c3 + c4));
			score += this.ts_(this.BQ3__.get(p3 + c2 + c3));
			score += this.ts_(this.BQ4__.get(p3 + c3 + c4));
			score += this.ts_(this.TQ1__.get(p2 + c1 + c2 + c3));
			score += this.ts_(this.TQ2__.get(p2 + c2 + c3 + c4));
			score += this.ts_(this.TQ3__.get(p3 + c1 + c2 + c3));
			score += this.ts_(this.TQ4__.get(p3 + c2 + c3 + c4));
			String p = "O";
			if (score > 0) {
				result.add(word.toString());
				word = new StringBuilder();
				p = "B";
			}
			p1 = p2;
			p2 = p3;
			p3 = p;
			word.append(seg.get(i));
		}
		result.add(word.toString());

		return result;
	}

	private HashMap<String, Integer> BC1__ = new HashMap<String, Integer>() {
		{
			put("HH", 6);
			put("II", 2461);
			put("KH", 406);
			put("OH", -1378);
		}
	};
	private HashMap<String, Integer> BC2__ = new HashMap<String, Integer>() {
		{
			put("AA", -3267);
			put("AI", 2744);
			put("AN", -878);
			put("HH", -4070);
			put("HM", -1711);
			put("HN", 4012);
			put("HO", 3761);
			put("IA", 1327);
			put("IH", -1184);
			put("II", -1332);
			put("IK", 1721);
			put("IO", 5492);
			put("KI", 3831);
			put("KK", -8741);
			put("MH", -3132);
			put("MK", 3334);
			put("OO", -2920);
		}
	};
	private HashMap<String, Integer> BC3__ = new HashMap<String, Integer>() {
		{
			put("HH", 996);
			put("HI", 626);
			put("HK", -721);
			put("HN", -1307);
			put("HO", -836);
			put("IH", -301);
			put("KK", 2762);
			put("MK", 1079);
			put("MM", 4034);
			put("OA", -1652);
			put("OH", 266);
		}
	};
	private HashMap<String, Integer> BP1__ = new HashMap<String, Integer>() {
		{
			put("BB", 295);
			put("OB", 304);
			put("OO", -125);
			put("UB", 352);
		}
	};
	private HashMap<String, Integer> BP2__ = new HashMap<String, Integer>() {
		{
			put("BO", 60);
			put("OO", -1762);
		}
	};
	private HashMap<String, Integer> BQ1__ = new HashMap<String, Integer>() {
		{
			put("BHH", 1150);
			put("BHM", 1521);
			put("BII", -1158);
			put("BIM", 886);
			put("BMH", 1208);
			put("BNH", 449);
			put("BOH", -91);
			put("BOO", -2597);
			put("OHI", 451);
			put("OIH", -296);
			put("OKA", 1851);
			put("OKH", -1020);
			put("OKK", 904);
			put("OOO", 2965);
		}
	};
	private HashMap<String, Integer> BQ2__ = new HashMap<String, Integer>() {
		{
			put("BHH", 118);
			put("BHI", -1159);
			put("BHM", 466);
			put("BIH", -919);
			put("BKK", -1720);
			put("BKO", 864);
			put("OHH", -1139);
			put("OHM", -181);
			put("OIH", 153);
			put("UHI", -1146);
		}
	};
	private HashMap<String, Integer> BQ3__ = new HashMap<String, Integer>() {
		{
			put("BHH", -792);
			put("BHI", 2664);
			put("BII", -299);
			put("BKI", 419);
			put("BMH", 937);
			put("BMM", 8335);
			put("BNN", 998);
			put("BOH", 775);
			put("OHH", 2174);
			put("OHM", 439);
			put("OII", 280);
			put("OKH", 1798);
			put("OKI", -793);
			put("OKO", -2242);
			put("OMH", -2402);
			put("OOO", 11699);
		}
	};
	private HashMap<String, Integer> BQ4__ = new HashMap<String, Integer>() {
		{
			put("BHH", -3895);
			put("BIH", 3761);
			put("BII", -4654);
			put("BIK", 1348);
			put("BKK", -1806);
			put("BMI", -3385);
			put("BOO", -12396);
			put("OAH", 926);
			put("OHH", 266);
			put("OHK", -2036);
			put("ONN", -973);
		}
	};
	private HashMap<String, Integer> BW1__ = new HashMap<String, Integer>() {
		{
			put(",と", 660);
			put(",同", 727);
			put("B1あ", 1404);
			put("B1同", 542);
			put("、と", 660);
			put("、同", 727);
			put("」と", 1682);
			put("あっ", 1505);
			put("いう", 1743);
			put("いっ", -2055);
			put("いる", 672);
			put("うし", -4817);
			put("うん", 665);
			put("から", 3472);
			put("がら", 600);
			put("こう", -790);
			put("こと", 2083);
			put("こん", -1262);
			put("さら", -4143);
			put("さん", 4573);
			put("した", 2641);
			put("して", 1104);
			put("すで", -3399);
			put("そこ", 1977);
			put("それ", -871);
			put("たち", 1122);
			put("ため", 601);
			put("った", 3463);
			put("つい", -802);
			put("てい", 805);
			put("てき", 1249);
			put("でき", 1127);
			put("です", 3445);
			put("では", 844);
			put("とい", -4915);
			put("とみ", 1922);
			put("どこ", 3887);
			put("ない", 5713);
			put("なっ", 3015);
			put("など", 7379);
			put("なん", -1113);
			put("にし", 2468);
			put("には", 1498);
			put("にも", 1671);
			put("に対", -912);
			put("の一", -501);
			put("の中", 741);
			put("ませ", 2448);
			put("まで", 1711);
			put("まま", 2600);
			put("まる", -2155);
			put("やむ", -1947);
			put("よっ", -2565);
			put("れた", 2369);
			put("れで", -913);
			put("をし", 1860);
			put("を見", 731);
			put("亡く", -1886);
			put("京都", 2558);
			put("取り", -2784);
			put("大き", -2604);
			put("大阪", 1497);
			put("平方", -2314);
			put("引き", -1336);
			put("日本", -195);
			put("本当", -2423);
			put("毎日", -2113);
			put("目指", -724);
			put("Ｂ１あ", 1404);
			put("Ｂ１同", 542);
			put("｣と", 1682);
		}
	};
	private HashMap<String, Integer> BW2__ = new HashMap<String, Integer>() {
		{
			put("..", -11822);
			put("11", -669);
			put("――", -5730);
			put("", -13175);
			put("いう", -1609);
			put("うか", 2490);
			put("かし", -1350);
			put("かも", -602);
			put("から", -7194);
			put("かれ", 4612);
			put("がい", 853);
			put("がら", -3198);
			put("きた", 1941);
			put("くな", -1597);
			put("こと", -8392);
			put("この", -4193);
			put("させ", 4533);
			put("され", 13168);
			put("さん", -3977);
			put("しい", -1819);
			put("しか", -545);
			put("した", 5078);
			put("して", 972);
			put("しな", 939);
			put("その", -3744);
			put("たい", -1253);
			put("たた", -662);
			put("ただ", -3857);
			put("たち", -786);
			put("たと", 1224);
			put("たは", -939);
			put("った", 4589);
			put("って", 1647);
			put("っと", -2094);
			put("てい", 6144);
			put("てき", 3640);
			put("てく", 2551);
			put("ては", -3110);
			put("ても", -3065);
			put("でい", 2666);
			put("でき", -1528);
			put("でし", -3828);
			put("です", -4761);
			put("でも", -4203);
			put("とい", 1890);
			put("とこ", -1746);
			put("とと", -2279);
			put("との", 720);
			put("とみ", 5168);
			put("とも", -3941);
			put("ない", -2488);
			put("なが", -1313);
			put("など", -6509);
			put("なの", 2614);
			put("なん", 3099);
			put("にお", -1615);
			put("にし", 2748);
			put("にな", 2454);
			put("によ", -7236);
			put("に対", -14943);
			put("に従", -4688);
			put("に関", -11388);
			put("のか", 2093);
			put("ので", -7059);
			put("のに", -6041);
			put("のの", -6125);
			put("はい", 1073);
			put("はが", -1033);
			put("はず", -2532);
			put("ばれ", 1813);
			put("まし", -1316);
			put("まで", -6621);
			put("まれ", 5409);
			put("めて", -3153);
			put("もい", 2230);
			put("もの", -10713);
			put("らか", -944);
			put("らし", -1611);
			put("らに", -1897);
			put("りし", 651);
			put("りま", 1620);
			put("れた", 4270);
			put("れて", 849);
			put("れば", 4114);
			put("ろう", 6067);
			put("われ", 7901);
			put("を通", -11877);
			put("んだ", 728);
			put("んな", -4115);
			put("一人", 602);
			put("一方", -1375);
			put("一日", 970);
			put("一部", -1051);
			put("上が", -4479);
			put("会社", -1116);
			put("出て", 2163);
			put("分の", -7758);
			put("同党", 970);
			put("同日", -913);
			put("大阪", -2471);
			put("委員", -1250);
			put("少な", -1050);
			put("年度", -8669);
			put("年間", -1626);
			put("府県", -2363);
			put("手権", -1982);
			put("新聞", -4066);
			put("日新", -722);
			put("日本", -7068);
			put("日米", 3372);
			put("曜日", -601);
			put("朝鮮", -2355);
			put("本人", -2697);
			put("東京", -1543);
			put("然と", -1384);
			put("社会", -1276);
			put("立て", -990);
			put("第に", -1612);
			put("米国", -4268);
			put("１１", -669);
		}
	};
	private HashMap<String, Integer> BW3__ = new HashMap<String, Integer>() {
		{
			put("あた", -2194);
			put("あり", 719);
			put("ある", 3846);
			put("い.", -1185);
			put("い。", -1185);
			put("いい", 5308);
			put("いえ", 2079);
			put("いく", 3029);
			put("いた", 2056);
			put("いっ", 1883);
			put("いる", 5600);
			put("いわ", 1527);
			put("うち", 1117);
			put("うと", 4798);
			put("えと", 1454);
			put("か.", 2857);
			put("か。", 2857);
			put("かけ", -743);
			put("かっ", -4098);
			put("かに", -669);
			put("から", 6520);
			put("かり", -2670);
			put("が,", 1816);
			put("が、", 1816);
			put("がき", -4855);
			put("がけ", -1127);
			put("がっ", -913);
			put("がら", -4977);
			put("がり", -2064);
			put("きた", 1645);
			put("けど", 1374);
			put("こと", 7397);
			put("この", 1542);
			put("ころ", -2757);
			put("さい", -714);
			put("さを", 976);
			put("し,", 1557);
			put("し、", 1557);
			put("しい", -3714);
			put("した", 3562);
			put("して", 1449);
			put("しな", 2608);
			put("しま", 1200);
			put("す.", -1310);
			put("す。", -1310);
			put("する", 6521);
			put("ず,", 3426);
			put("ず、", 3426);
			put("ずに", 841);
			put("そう", 428);
			put("た.", 8875);
			put("た。", 8875);
			put("たい", -594);
			put("たの", 812);
			put("たり", -1183);
			put("たる", -853);
			put("だ.", 4098);
			put("だ。", 4098);
			put("だっ", 1004);
			put("った", -4748);
			put("って", 300);
			put("てい", 6240);
			put("てお", 855);
			put("ても", 302);
			put("です", 1437);
			put("でに", -1482);
			put("では", 2295);
			put("とう", -1387);
			put("とし", 2266);
			put("との", 541);
			put("とも", -3543);
			put("どう", 4664);
			put("ない", 1796);
			put("なく", -903);
			put("など", 2135);
			put("に,", -1021);
			put("に、", -1021);
			put("にし", 1771);
			put("にな", 1906);
			put("には", 2644);
			put("の,", -724);
			put("の、", -724);
			put("の子", -1000);
			put("は,", 1337);
			put("は、", 1337);
			put("べき", 2181);
			put("まし", 1113);
			put("ます", 6943);
			put("まっ", -1549);
			put("まで", 6154);
			put("まれ", -793);
			put("らし", 1479);
			put("られ", 6820);
			put("るる", 3818);
			put("れ,", 854);
			put("れ、", 854);
			put("れた", 1850);
			put("れて", 1375);
			put("れば", -3246);
			put("れる", 1091);
			put("われ", -605);
			put("んだ", 606);
			put("んで", 798);
			put("カ月", 990);
			put("会議", 860);
			put("入り", 1232);
			put("大会", 2217);
			put("始め", 1681);
			put("市", 965);
			put("新聞", -5055);
			put("日,", 974);
			put("日、", 974);
			put("社会", 2024);
			put("ｶ月", 990);
		}
	};
	private HashMap<String, Integer> TC1__ = new HashMap<String, Integer>() {
		{
			put("AAA", 1093);
			put("HHH", 1029);
			put("HHM", 580);
			put("HII", 998);
			put("HOH", -390);
			put("HOM", -331);
			put("IHI", 1169);
			put("IOH", -142);
			put("IOI", -1015);
			put("IOM", 467);
			put("MMH", 187);
			put("OOI", -1832);
		}
	};
	private HashMap<String, Integer> TC2__ = new HashMap<String, Integer>() {
		{
			put("HHO", 2088);
			put("HII", -1023);
			put("HMM", -1154);
			put("IHI", -1965);
			put("KKH", 703);
			put("OII", -2649);
		}
	};
	private HashMap<String, Integer> TC3__ = new HashMap<String, Integer>() {
		{
			put("AAA", -294);
			put("HHH", 346);
			put("HHI", -341);
			put("HII", -1088);
			put("HIK", 731);
			put("HOH", -1486);
			put("IHH", 128);
			put("IHI", -3041);
			put("IHO", -1935);
			put("IIH", -825);
			put("IIM", -1035);
			put("IOI", -542);
			put("KHH", -1216);
			put("KKA", 491);
			put("KKH", -1217);
			put("KOK", -1009);
			put("MHH", -2694);
			put("MHM", -457);
			put("MHO", 123);
			put("MMH", -471);
			put("NNH", -1689);
			put("NNO", 662);
			put("OHO", -3393);
		}
	};
	private HashMap<String, Integer> TC4__ = new HashMap<String, Integer>() {
		{
			put("HHH", -203);
			put("HHI", 1344);
			put("HHK", 365);
			put("HHM", -122);
			put("HHN", 182);
			put("HHO", 669);
			put("HIH", 804);
			put("HII", 679);
			put("HOH", 446);
			put("IHH", 695);
			put("IHO", -2324);
			put("IIH", 321);
			put("III", 1497);
			put("IIO", 656);
			put("IOO", 54);
			put("KAK", 4845);
			put("KKA", 3386);
			put("KKK", 3065);
			put("MHH", -405);
			put("MHI", 201);
			put("MMH", -241);
			put("MMM", 661);
			put("MOM", 841);
		}
	};
	private HashMap<String, Integer> TQ1__ = new HashMap<String, Integer>() {
		{
			put("BHHH", -227);
			put("BHHI", 316);
			put("BHIH", -132);
			put("BIHH", 60);
			put("BIII", 1595);
			put("BNHH", -744);
			put("BOHH", 225);
			put("BOOO", -908);
			put("OAKK", 482);
			put("OHHH", 281);
			put("OHIH", 249);
			put("OIHI", 200);
			put("OIIH", -68);
		}
	};
	private HashMap<String, Integer> TQ2__ = new HashMap<String, Integer>() {
		{
			put("BIHH", -1401);
			put("BIII", -1033);
			put("BKAK", -543);
			put("BOOO", -5591);
		}
	};
	private HashMap<String, Integer> TQ3__ = new HashMap<String, Integer>() {
		{
			put("BHHH", 478);
			put("BHHM", -1073);
			put("BHIH", 222);
			put("BHII", -504);
			put("BIIH", -116);
			put("BIII", -105);
			put("BMHI", -863);
			put("BMHM", -464);
			put("BOMH", 620);
			put("OHHH", 346);
			put("OHHI", 1729);
			put("OHII", 997);
			put("OHMH", 481);
			put("OIHH", 623);
			put("OIIH", 1344);
			put("OKAK", 2792);
			put("OKHH", 587);
			put("OKKA", 679);
			put("OOHH", 110);
			put("OOII", -685);
		}
	};
	private HashMap<String, Integer> TQ4__ = new HashMap<String, Integer>() {
		{
			put("BHHH", -721);
			put("BHHM", -3604);
			put("BHII", -966);
			put("BIIH", -607);
			put("BIII", -2181);
			put("OAAA", -2763);
			put("OAKK", 180);
			put("OHHH", -294);
			put("OHHI", 2446);
			put("OHHO", 480);
			put("OHIH", -1573);
			put("OIHH", 1935);
			put("OIHI", -493);
			put("OIIH", 626);
			put("OIII", -4007);
			put("OKAK", -8156);
		}
	};
	private HashMap<String, Integer> TW1__ = new HashMap<String, Integer>() {
		{
			put("につい", -4681);
			put("東京都", 2026);
		}
	};
	private HashMap<String, Integer> TW2__ = new HashMap<String, Integer>() {
		{
			put("ある程", -2049);
			put("いった", -1256);
			put("ころが", -2434);
			put("しょう", 3873);
			put("その後", -4430);
			put("だって", -1049);
			put("ていた", 1833);
			put("として", -4657);
			put("ともに", -4517);
			put("もので", 1882);
			put("一気に", -792);
			put("初めて", -1512);
			put("同時に", -8097);
			put("大きな", -1255);
			put("対して", -2721);
			put("社会党", -3216);
		}
	};
	private HashMap<String, Integer> TW3__ = new HashMap<String, Integer>() {
		{
			put("いただ", -1734);
			put("してい", 1314);
			put("として", -4314);
			put("につい", -5483);
			put("にとっ", -5989);
			put("に当た", -6247);
			put("ので,", -727);
			put("ので、", -727);
			put("のもの", -600);
			put("れから", -3752);
			put("十二月", -2287);
		}
	};
	private HashMap<String, Integer> TW4__ = new HashMap<String, Integer>() {
		{
			put("いう.", 8576);
			put("いう。", 8576);
			put("からな", -2348);
			put("してい", 2958);
			put("たが,", 1516);
			put("たが、", 1516);
			put("ている", 1538);
			put("という", 1349);
			put("ました", 5543);
			put("ません", 1097);
			put("ようと", -4258);
			put("よると", 5865);
		}
	};
	private HashMap<String, Integer> UC1__ = new HashMap<String, Integer>() {
		{
			put("A", 484);
			put("K", 93);
			put("M", 645);
			put("O", -505);
		}
	};
	private HashMap<String, Integer> UC2__ = new HashMap<String, Integer>() {
		{
			put("A", 819);
			put("H", 1059);
			put("I", 409);
			put("M", 3987);
			put("N", 5775);
			put("O", 646);
		}
	};
	private HashMap<String, Integer> UC3__ = new HashMap<String, Integer>() {
		{
			put("A", -1370);
			put("I", 2311);
		}
	};
	private HashMap<String, Integer> UC4__ = new HashMap<String, Integer>() {
		{
			put("A", -2643);
			put("H", 1809);
			put("I", -1032);
			put("K", -3450);
			put("M", 3565);
			put("N", 3876);
			put("O", 6646);
		}
	};
	private HashMap<String, Integer> UC5__ = new HashMap<String, Integer>() {
		{
			put("H", 313);
			put("I", -1238);
			put("K", -799);
			put("M", 539);
			put("O", -831);
		}
	};
	private HashMap<String, Integer> UC6__ = new HashMap<String, Integer>() {
		{
			put("H", -506);
			put("I", -253);
			put("K", 87);
			put("M", 247);
			put("O", -387);
		}
	};
	private HashMap<String, Integer> UP1__ = new HashMap<String, Integer>() {
		{
			put("O", -214);
		}
	};
	private HashMap<String, Integer> UP2__ = new HashMap<String, Integer>() {
		{
			put("B", 69);
			put("O", 935);
		}
	};
	private HashMap<String, Integer> UP3__ = new HashMap<String, Integer>() {
		{
			put("B", 189);
		}
	};
	private HashMap<String, Integer> UQ1__ = new HashMap<String, Integer>() {
		{
			put("BH", 21);
			put("BI", -12);
			put("BK", -99);
			put("BN", 142);
			put("BO", -56);
			put("OH", -95);
			put("OI", 477);
			put("OK", 410);
			put("OO", -2422);
		}
	};
	private HashMap<String, Integer> UQ2__ = new HashMap<String, Integer>() {
		{
			put("BH", 216);
			put("BI", 113);
			put("OK", 1759);
		}
	};
	private HashMap<String, Integer> UQ3__ = new HashMap<String, Integer>() {
		{
			put("BA", -479);
			put("BH", 42);
			put("BI", 1913);
			put("BK", -7198);
			put("BM", 3160);
			put("BN", 6427);
			put("BO", 14761);
			put("OI", -827);
			put("ON", -3212);
		}
	};
	private HashMap<String, Integer> UW1__ = new HashMap<String, Integer>() {
		{
			put(",", 156);
			put("、", 156);
			put("「", -463);
			put("あ", -941);
			put("う", -127);
			put("が", -553);
			put("き", 121);
			put("こ", 505);
			put("で", -201);
			put("と", -547);
			put("ど", -123);
			put("に", -789);
			put("の", -185);
			put("は", -847);
			put("も", -466);
			put("や", -470);
			put("よ", 182);
			put("ら", -292);
			put("り", 208);
			put("れ", 169);
			put("を", -446);
			put("ん", -137);
			put("・", -135);
			put("主", -402);
			put("京", -268);
			put("区", -912);
			put("午", 871);
			put("国", -460);
			put("大", 561);
			put("委", 729);
			put("市", -411);
			put("日", -141);
			put("理", 361);
			put("生", -408);
			put("県", -386);
			put("都", -718);
			put("｢", -463);
			put("･", -135);
		}
	};
	private HashMap<String, Integer> UW2__ = new HashMap<String, Integer>() {
		{
			put(",", -829);
			put("、", -829);
			put("〇", 892);
			put("「", -645);
			put("」", 3145);
			put("あ", -538);
			put("い", 505);
			put("う", 134);
			put("お", -502);
			put("か", 1454);
			put("が", -856);
			put("く", -412);
			put("こ", 1141);
			put("さ", 878);
			put("ざ", 540);
			put("し", 1529);
			put("す", -675);
			put("せ", 300);
			put("そ", -1011);
			put("た", 188);
			put("だ", 1837);
			put("つ", -949);
			put("て", -291);
			put("で", -268);
			put("と", -981);
			put("ど", 1273);
			put("な", 1063);
			put("に", -1764);
			put("の", 130);
			put("は", -409);
			put("ひ", -1273);
			put("べ", 1261);
			put("ま", 600);
			put("も", -1263);
			put("や", -402);
			put("よ", 1639);
			put("り", -579);
			put("る", -694);
			put("れ", 571);
			put("を", -2516);
			put("ん", 2095);
			put("ア", -587);
			put("カ", 306);
			put("キ", 568);
			put("ッ", 831);
			put("三", -758);
			put("不", -2150);
			put("世", -302);
			put("中", -968);
			put("主", -861);
			put("事", 492);
			put("人", -123);
			put("会", 978);
			put("保", 362);
			put("入", 548);
			put("初", -3025);
			put("副", -1566);
			put("北", -3414);
			put("区", -422);
			put("大", -1769);
			put("天", -865);
			put("太", -483);
			put("子", -1519);
			put("学", 760);
			put("実", 1023);
			put("小", -2009);
			put("市", -813);
			put("年", -1060);
			put("強", 1067);
			put("手", -1519);
			put("揺", -1033);
			put("政", 1522);
			put("文", -1355);
			put("新", -1682);
			put("日", -1815);
			put("明", -1462);
			put("最", -630);
			put("朝", -1843);
			put("本", -1650);
			put("東", -931);
			put("果", -665);
			put("次", -2378);
			put("民", -180);
			put("気", -1740);
			put("理", 752);
			put("発", 529);
			put("目", -1584);
			put("相", -242);
			put("県", -1165);
			put("立", -763);
			put("第", 810);
			put("米", 509);
			put("自", -1353);
			put("行", 838);
			put("西", -744);
			put("見", -3874);
			put("調", 1010);
			put("議", 1198);
			put("込", 3041);
			put("開", 1758);
			put("間", -1257);
			put("｢", -645);
			put("｣", 3145);
			put("ｯ", 831);
			put("ｱ", -587);
			put("ｶ", 306);
			put("ｷ", 568);
		}
	};
	private HashMap<String, Integer> UW3__ = new HashMap<String, Integer>() {
		{
			put(",", 4889);
			put("1", -800);
			put(":278", 278);
		}
	};
	private HashMap<String, Integer> UW4__ = new HashMap<String, Integer>() {
		{
			put(",", 3930);
			put(".", 3508);
			put("―", -4841);
			put("、", 3930);
			put("。", 3508);
			put("〇", 4999);
			put("「", 1895);
			put("」", 3798);
			put("〓", -5156);
			put("あ", 4752);
			put("い", -3435);
			put("う", -640);
			put("え", -2514);
			put("お", 2405);
			put("か", 530);
			put("が", 6006);
			put("き", -4482);
			put("ぎ", -3821);
			put("く", -3788);
			put("け", -4376);
			put("げ", -4734);
			put("こ", 2255);
			put("ご", 1979);
			put("さ", 2864);
			put("し", -843);
			put("じ", -2506);
			put("す", -731);
			put("ず", 1251);
			put("せ", 181);
			put("そ", 4091);
			put("た", 5034);
			put("だ", 5408);
			put("ち", -3654);
			put("っ", -5882);
			put("つ", -1659);
			put("て", 3994);
			put("で", 7410);
			put("と", 4547);
			put("な", 5433);
			put("に", 6499);
			put("ぬ", 1853);
			put("ね", 1413);
			put("の", 7396);
			put("は", 8578);
			put("ば", 1940);
			put("ひ", 4249);
			put("び", -4134);
			put("ふ", 1345);
			put("へ", 6665);
			put("べ", -744);
			put("ほ", 1464);
			put("ま", 1051);
			put("み", -2082);
			put("む", -882);
			put("め", -5046);
			put("も", 4169);
			put("ゃ", -2666);
			put("や", 2795);
			put("ょ", -1544);
			put("よ", 3351);
			put("ら", -2922);
			put("り", -9726);
			put("る", -14896);
			put("れ", -2613);
			put("ろ", -4570);
			put("わ", -1783);
			put("を", 13150);
			put("ん", -2352);
			put("カ", 2145);
			put("コ", 1789);
			put("セ", 1287);
			put("ッ", -724);
			put("ト", -403);
			put("メ", -1635);
			put("ラ", -881);
			put("リ", -541);
			put("ル", -856);
			put("ン", -3637);
			put("・", -4371);
			put("ー", -11870);
			put("一", -2069);
			put("中", 2210);
			put("予", 782);
			put("事", -190);
			put("井", -1768);
			put("人", 1036);
			put("以", 544);
			put("会", 950);
			put("体", -1286);
			put("作", 530);
			put("側", 4292);
			put("先", 601);
			put("党", -2006);
			put("共", -1212);
			put("内", 584);
			put("円", 788);
			put("初", 1347);
			put("前", 1623);
			put("副", 3879);
			put("力", -302);
			put("動", -740);
			put("務", -2715);
			put("化", 776);
			put("区", 4517);
			put("協", 1013);
			put("参", 1555);
			put("合", -1834);
			put("和", -681);
			put("員", -910);
			put("器", -851);
			put("回", 1500);
			put("国", -619);
			put("園", -1200);
			put("地", 866);
			put("場", -1410);
			put("塁", -2094);
			put("士", -1413);
			put("多", 1067);
			put("大", 571);
			put("子", -4802);
			put("学", -1397);
			put("定", -1057);
			put("寺", -809);
			put("小", 1910);
			put("屋", -1328);
			put("山", -1500);
			put("島", -2056);
			put("川", -2667);
			put("市", 2771);
			put("年", 374);
			put("庁", -4556);
			put("後", 456);
			put("性", 553);
			put("感", 916);
			put("所", -1566);
			put("支", 856);
			put("改", 787);
			put("政", 2182);
			put("教", 704);
			put("文", 522);
			put("方", -856);
			put("日", 1798);
			put("時", 1829);
			put("最", 845);
			put("月", -9066);
			put("木", -485);
			put("来", -442);
			put("校", -360);
			put("業", -1043);
			put("氏", 5388);
			put("民", -2716);
			put("気", -910);
			put("沢", -939);
			put("済", -543);
			put("物", -735);
			put("率", 672);
			put("球", -1267);
			put("生", -1286);
			put("産", -1101);
			put("田", -2900);
			put("町", 1826);
			put("的", 2586);
			put("目", 922);
			put("省", -3485);
			put("県", 2997);
			put("空", -867);
			put("立", -2112);
			put("第", 788);
			put("米", 2937);
			put("系", 786);
			put("約", 2171);
			put("経", 1146);
			put("統", -1169);
			put("総", 940);
			put("線", -994);
			put("署", 749);
			put("者", 2145);
			put("能", -730);
			put("般", -852);
			put("行", -792);
			put("規", 792);
			put("警", -1184);
			put("議", -244);
			put("谷", -1000);
			put("賞", 730);
			put("車", -1481);
			put("軍", 1158);
			put("輪", -1433);
			put("込", -3370);
			put("近", 929);
			put("道", -1291);
			put("選", 2596);
			put("郎", -4866);
			put("都", 1192);
			put("野", -1100);
			put("銀", -2213);
			put("長", 357);
			put("間", -2344);
			put("院", -2297);
			put("際", -2604);
			put("電", -878);
			put("領", -1659);
			put("題", -792);
			put("館", -1984);
			put("首", 1749);
			put("高", 2120);
			put("｢", 1895);
			put("｣", 3798);
			put("･", -4371);
			put("ｯ", -724);
			put("ｰ", -11870);
			put("ｶ", 2145);
			put("ｺ", 1789);
			put("ｾ", 1287);
			put("ﾄ", -403);
			put("ﾒ", -1635);
			put("ﾗ", -881);
			put("ﾘ", -541);
			put("ﾙ", -856);
			put("ﾝ", -3637);
		}
	};
	private HashMap<String, Integer> UW5__ = new HashMap<String, Integer>() {
		{
			put(",", 465);
			put(".", -299);
			put("1", -514);
			put("E2", -32768);
			put("]", -2762);
			put("、", 465);
			put("。", -299);
			put("「", 363);
			put("あ", 1655);
			put("い", 331);
			put("う", -503);
			put("え", 1199);
			put("お", 527);
			put("か", 647);
			put("が", -421);
			put("き", 1624);
			put("ぎ", 1971);
			put("く", 312);
			put("げ", -983);
			put("さ", -1537);
			put("し", -1371);
			put("す", -852);
			put("だ", -1186);
			put("ち", 1093);
			put("っ", 52);
			put("つ", 921);
			put("て", -18);
			put("で", -850);
			put("と", -127);
			put("ど", 1682);
			put("な", -787);
			put("に", -1224);
			put("の", -635);
			put("は", -578);
			put("べ", 1001);
			put("み", 502);
			put("め", 865);
			put("ゃ", 3350);
			put("ょ", 854);
			put("り", -208);
			put("る", 429);
			put("れ", 504);
			put("わ", 419);
			put("を", -1264);
			put("ん", 327);
			put("イ", 241);
			put("ル", 451);
			put("ン", -343);
			put("中", -871);
			put("京", 722);
			put("会", -1153);
			put("党", -654);
			put("務", 3519);
			put("区", -901);
			put("告", 848);
			put("員", 2104);
			put("大", -1296);
			put("学", -548);
			put("定", 1785);
			put("嵐", -1304);
			put("市", -2991);
			put("席", 921);
			put("年", 1763);
			put("思", 872);
			put("所", -814);
			put("挙", 1618);
			put("新", -1682);
			put("日", 218);
			put("月", -4353);
			put("査", 932);
			put("格", 1356);
			put("機", -1508);
			put("氏", -1347);
			put("田", 240);
			put("町", -3912);
			put("的", -3149);
			put("相", 1319);
			put("省", -1052);
			put("県", -4003);
			put("研", -997);
			put("社", -278);
			put("空", -813);
			put("統", 1955);
			put("者", -2233);
			put("表", 663);
			put("語", -1073);
			put("議", 1219);
			put("選", -1018);
			put("郎", -368);
			put("長", 786);
			put("間", 1191);
			put("題", 2368);
			put("館", -689);
			put("１", -514);
			put("Ｅ２", -32768);
			put("｢", 363);
			put("ｲ", 241);
			put("ﾙ", 451);
			put("ﾝ", -343);
		}
	};
	private HashMap<String, Integer> UW6__ = new HashMap<String, Integer>() {
		{
			put(",", 227);
			put(".", 808);
			put("1", -270);
			put("E1", 306);
			put("、", 227);
			put("。", 808);
			put("あ", -307);
			put("う", 189);
			put("か", 241);
			put("が", -73);
			put("く", -121);
			put("こ", -200);
			put("じ", 1782);
			put("す", 383);
			put("た", -428);
			put("っ", 573);
			put("て", -1014);
			put("で", 101);
			put("と", -105);
			put("な", -253);
			put("に", -149);
			put("の", -417);
			put("は", -236);
			put("も", -206);
			put("り", 187);
			put("る", -135);
			put("を", 195);
			put("ル", -673);
			put("ン", -496);
			put("一", -277);
			put("中", 201);
			put("件", -800);
			put("会", 624);
			put("前", 302);
			put("区", 1792);
			put("員", -1212);
			put("委", 798);
			put("学", -960);
			put("市", 887);
			put("広", -695);
			put("後", 535);
			put("業", -697);
			put("相", 753);
			put("社", -507);
			put("福", 974);
			put("空", -822);
			put("者", 1811);
			put("連", 463);
			put("郎", 1082);
			put("１", -270);
			put("Ｅ１", 306);
			put("ﾙ", -673);
			put("ﾝ", -496);
		}
	};
}
