/*
 * IRCChannelUser.java
 * IRCCore
 *
 * Created by tarchan on 2007/02/02.
 * Copyright (c) 2007 tarchan. All rights reserved.
 */
package com.mac.tarchan.irc;

/**
 * IRCChannelUser
 * 
 * @author tarchan
 * @author nori090
 */
public class IRCChannelUser {
    private IRCChannel ch;

    private IRCUser user;

    public IRCChannelUser( IRCChannel ch, IRCUser user ) {
        this.ch = ch;
        this.user = user;
    }

    public IRCChannel getChannel() {
        return ch;
    }

    public IRCUser getUser() {
        return user;
    }

    public String getNick() {
        return user.getNick();
    }

    public String getMode() {
        return user.getMode();
    }

    public boolean isAway() {
        return user.isAway();
    }

    public String getAwayMessage() {
        return user.getAwayMessage();
    }

    public String toString() {
        return user.getNick();
    }
}
