package org.coderepos.nori090;

import java.util.Enumeration;
import java.util.Vector;

public class ShutdownThread
    extends Thread {
    Vector<ShutdownListener> listeners = new Vector<ShutdownListener>();

    public void addListener( ShutdownListener listener ) {
        listeners.add( listener );
    }

    public ShutdownThread() {
        super( "shutdown hook thread" );
    }

    @Override
    public void run() {
        System.out.println("shutdown...");
        for ( Enumeration<ShutdownListener> e = listeners.elements(); e.hasMoreElements(); ) {
            ShutdownListener listener = e.nextElement();
            System.out.println("call shutdown listener:"+listener.getProcessName());
            listener.shutdown( this );
        }
        System.out.println("shutdown...ok");
    }
}
