/*
 * IRCAddressTest.java
 * IRCCoreTest
 *
 * Created by tarchan on Nov 29, 2006.
 * Copyright (c) 2006 tarchan. All rights reserved.
 */
package com.mac.tarchan.irc;

import junit.framework.TestCase;
import com.mac.tarchan.irc.IRCAddress;

/**
 * IRCAddressTest
 * 
 * @author tarchan
 * @author nori090
 */
public class IRCAddressTest extends TestCase {
	public void testAddress001() {
		IRCAddress addr = new IRCAddress(
				"irc://user:pass@irc.tokyo.wide.ad.jp:6669/#dameTunes");
		String host = addr.getHost();
		assertEquals("irc.tokyo.wide.ad.jp", host);
		assertEquals(6669, addr.getPort());
		assertEquals("#dameTunes", addr.getChannel());
		assertEquals("user", addr.getUser());
		assertEquals("pass", addr.getPassword());
	}

	public void testAddress002() {
		IRCAddress addr = new IRCAddress("irc://irc.tokyo.wide.ad.jp");
		String host = addr.getHost();
		assertEquals("irc.tokyo.wide.ad.jp", host);
		assertEquals(6667, addr.getPort());
		assertEquals(null, addr.getChannel());
		assertEquals(null, addr.getUser());
		assertEquals(null, addr.getPassword());
	}

	public void testAddress003() {
		// tarchan:mahotai!@ayumayu.fam.cx/#dameTunes
		// tarchan:mahotai!@ayumayu.fam.cx/irc#dameTunes
		IRCAddress addr = new IRCAddress(
				"user:pass@ayumayu.fam.cx/irc#dameTunes");
		String host = addr.getHost();
		assertEquals("ayumayu.fam.cx", host);
		assertEquals(6667, addr.getPort());
		assertEquals("#dameTunes", addr.getChannel());
		assertEquals("user", addr.getUser());
		assertEquals("pass", addr.getPassword());
	}
	
	public void testAddress004() {
		IRCAddress addr = new IRCAddress(
				"user:@ayumayu.fam.cx/irc#dameTunes");
		String host = addr.getHost();
		assertEquals("ayumayu.fam.cx", host);
		assertEquals(6667, addr.getPort());
		assertEquals("#dameTunes", addr.getChannel());
		assertEquals("user", addr.getUser());
		assertEquals("", addr.getPassword());
	}

}
