/*
 * StringArrayTest.java
 * IRCCoreTest
 *
 * Created by tarchan on 2006/12/25.
 * Copyright (c) 2006 tarchan. All rights reserved.
 */
package com.mac.tarchan.misc;

import com.mac.tarchan.misc.StringArray;

import junit.framework.TestCase;


/**
 * StringArrayTest
 *
 * @author tarchan
 */
public class StringArrayTest extends TestCase
{
	public void testSplit001()
	{
		StringArray sa = StringArray.split("@matuken @Kaho @m_mai hideo masan_Zzz ", " ");
		assertEquals("@matuken", sa.indexAt(0));
	}

	public void testSplit011()
	{
		StringArray sa = StringArray.split("tarc2!~tarchan@221x254x0x23.ap221.ftth.ucom.ne.jp", "!", "@");
		assertEquals("tarc2", sa.indexAt(0));
	}

	public void testSplit012()
	{
		StringArray sa = StringArray.split("tarc2!~tarchan@221x254x0x23.ap221.ftth.ucom.ne.jp", "!", "@");
		assertEquals("~tarchan", sa.indexAt(1));
	}

	public void testSplit013()
	{
		StringArray sa = StringArray.split("tarc2!~tarchan@221x254x0x23.ap221.ftth.ucom.ne.jp", "!", "@");
		assertEquals("221x254x0x23.ap221.ftth.ucom.ne.jp", sa.indexAt(2));
	}

	public void testSplit021()
	{
		StringArray sa = StringArray.split("tarc2", "!", "@");
		assertEquals("tarc2", sa.indexAt(0));
	}

	public void testSplit022()
	{
		StringArray sa = StringArray.split("tarc2", "!", "@");
		assertEquals("", sa.indexAt(1));
	}

	public void testSplit023()
	{
		StringArray sa = StringArray.split("tarc2", "!", "@");
		assertEquals("", sa.indexAt(2));
	}

	public void testJoin001()
	{
		StringArray sa = StringArray.split("@matuken @Kaho @m_mai hideo masan_Zzz ", " ");
		assertEquals("@matuken,@Kaho,@m_mai,hideo,masan_Zzz", sa.join(","));
	}

	public void testContains001()
	{
		StringArray sa = StringArray.split("@matuken @Kaho @m_mai hideo masan_Zzz ", " ");
		assertEquals(false, sa.contains("masan_zzz"));
	}

	public void testContains002()
	{
		StringArray sa = StringArray.split("@matuken @Kaho @m_mai hideo masan_Zzz ", " ");
		assertEquals(true, sa.containsIgnoreCase("masan_zzz"));
	}
}
