/*
 * Copyright 2007 nori090
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jimmy.command;

import java.io.ByteArrayOutputStream;
import java.net.InetAddress;

import jimmy.ConvertUtil;
import jimmy.WinnyProtocolException;
import jimmy.util._ByteArrayInputStream;

/**
 * winny node details command
 * 
 * @author nori090
 * @version $Rev: 17 $ $Date: 2008-03-25 22:45:24 +0900 (Tue, 25 Mar 2008) $
 */
public class Command03
    extends Command {

    InetAddress address;

    int listen_port;

    String ddns_name = "";

    String[] clustering_key = new String[3];

    @Override
    void rawDataPack()
        throws WinnyProtocolException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write( address.getAddress() );
            out.write( ConvertUtil.toLittleEndianBytes( listen_port ) );
            out.write( ddns_name.length() );
            for ( String s : clustering_key ) {
                if ( s != null && s.length() != 0 ) {
                    out.write( s.getBytes( "windows-31j" ).length );
                }
                else {
                    out.write( 0 );
                }
            }
            if ( ddns_name != null & ddns_name.length() != 0 ) {
                out.write( ddns_name.getBytes( "Windows-31J" ) );
            }
            for ( String s : clustering_key ) {
                if ( s != null && s.length() != 0 ) {
                    out.write( s.getBytes( "Windows-31J" ) );
                }
            }
            data = out.toByteArray();
        }
        catch ( Exception e ) {
            throw new WinnyProtocolException( e );
        }
        finally {
            try {
                // ByteArrayOutputStreamは意味内けど
                out.close();
            }
            catch ( Exception e ) {
                e.printStackTrace();
            }
        }
    }

    @Override
    void rawDataUnpack()
        throws WinnyProtocolException {
        _ByteArrayInputStream in = new _ByteArrayInputStream( data );
        try {
            address = InetAddress.getByAddress( in.read( 4 ) );
            listen_port = ConvertUtil.littleEndianBytes2int( in.read( 4 ) );
            int ddnsname_length = in.read();
            int clustering_key_length1 = in.read();
            int clustering_key_length2 = in.read();
            int clustering_key_length3 = in.read();
            ddns_name = new String( in.read( ddnsname_length ) );
            clustering_key =
                new String[] { new String( in.read( clustering_key_length1 ), "Windows-31J" ),
                    new String( in.read( clustering_key_length2 ), "Windows-31J" ),
                    new String( in.read( clustering_key_length3 ), "Windows-31J" ) };
        }
        catch ( Exception e ) {
            e.printStackTrace();
            throw new WinnyProtocolException( e );
        }
        finally {
            try {
                in.close();
            }
            catch ( Exception e ) {
                e.printStackTrace();
            }
        }
    }

    public InetAddress getAddress() {
        return address;
    }

    public void setAddress( InetAddress address ) {
        this.address = address;
    }

    public int getListen_port() {
        return listen_port;
    }

    public void setListen_port( int listen_port ) {
        this.listen_port = listen_port;
    }

    public String getDdns_name() {
        return ddns_name;
    }

    public void setDdns_name( String ddns_name ) {
        this.ddns_name = ddns_name;
    }

    public String[] getClustering_key() {
        return clustering_key;
    }

    public void setClustering_key( String[] clustering_key ) {
        this.clustering_key = clustering_key;
    }

}
