/*
 * Copyright 2007 nori090
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jimmy.command;

import java.io.ByteArrayOutputStream;

import jimmy.ConvertUtil;
import jimmy.WinnyProtocolException;
import jimmy.util._ByteArrayInputStream;

/**
 * winny File Request command
 * 
 * @author nori090
 * @version $Rev: 17 $ $Date: 2008-03-25 22:45:24 +0900 (Tue, 25 Mar 2008) $
 */
public class Command11
    extends Command {

    int task_id;

    int begin_block_num;

    int request_block_count;

    byte[] file_hash = new byte[0];

    int file_size;

    @Override
    void rawDataPack()
        throws WinnyProtocolException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write( ConvertUtil.toLittleEndianBytes( task_id ) );
            out.write( ConvertUtil.toLittleEndianBytes( begin_block_num ) );
            out.write( ConvertUtil.toLittleEndianBytes( request_block_count ) );
            out.write( file_hash );
            out.write( ConvertUtil.toLittleEndianBytes( file_size ) );
            data = out.toByteArray();
        }
        catch ( Exception e ) {
            throw new WinnyProtocolException( e );
        }
        finally {
            try {
                out.close();
            }
            catch ( Exception e ) {
                e.printStackTrace();
            }
        }
    }

    @Override
    void rawDataUnpack()
        throws WinnyProtocolException {
        _ByteArrayInputStream in = new _ByteArrayInputStream( data );
        try {
            task_id = ConvertUtil.littleEndianBytes2int( in.read( 4 ) );
            begin_block_num = ConvertUtil.littleEndianBytes2int( in.read( 4 ) );
            request_block_count = ConvertUtil.littleEndianBytes2int( in.read( 4 ) );
            file_hash = in.read( 16 );
            file_size = ConvertUtil.littleEndianBytes2int( in.read( 4 ) );
        }
        catch ( Exception e ) {
            e.printStackTrace();
            throw new WinnyProtocolException( e );
        }
        finally {
            try {
                in.close();
            }
            catch ( Exception e ) {
                e.printStackTrace();
            }
        }
    }

    public int getTask_id() {
        return task_id;
    }

    public void setTask_id( int task_id ) {
        this.task_id = task_id;
    }

    public int getBegin_block_num() {
        return begin_block_num;
    }

    public void setBegin_block_num( int begin_block_num ) {
        this.begin_block_num = begin_block_num;
    }

    public int getRequest_block_count() {
        return request_block_count;
    }

    public void setRequest_block_count( int request_block_count ) {
        this.request_block_count = request_block_count;
    }

    public byte[] getFile_hash() {
        return file_hash;
    }

    public void setFile_hash( byte[] file_hash ) {
        this.file_hash = file_hash;
    }

    public int getFile_size() {
        return file_size;
    }

    public void setFile_size( int file_size ) {
        this.file_size = file_size;
    }

}
