/*
 * Copyright 2007 nori090
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jimmy.command;

import java.io.ByteArrayOutputStream;

import jimmy.ConvertUtil;
import jimmy.WinnyProtocolException;
import jimmy.util._ByteArrayInputStream;

/**
 * winny Conditional Diffusion Request command
 * 
 * @author nori090
 * @version $Rev: 17 $ $Date: 2008-03-25 22:45:24 +0900 (Tue, 25 Mar 2008) $
 */
public class Command12
    extends Command {
    String keyword = "";

    String trip = "";

    int query_id;

    @Override
    void rawDataPack()
        throws WinnyProtocolException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            if ( keyword != null && keyword.length() != 0 ) {
                byte[] bs = keyword.getBytes( "windows-31j" );
                if ( bs.length > 0xff ) {
                    out.write( bs, 0, 0xff );
                }
                else {
                    out.write( bs );
                    for ( int i = bs.length; i < 0xff; i++ ) {
                        out.write( 0 );
                    }
                }
            }
            else {
                for ( int i = 0; i < 0xff; i++ ) {
                    out.write( 0 );
                }
            }
            if ( trip != null && trip.length() != 0 ) {
                byte[] bs = trip.getBytes( "windows-31j" );
                if ( bs.length > 0xf ) {
                    out.write( bs, 0, 0xf );
                }
                else {
                    out.write( bs );
                    for ( int i = bs.length; i < 0xf; i++ ) {
                        out.write( 0 );
                    }
                }
            }
            out.write( ConvertUtil.toLittleEndianBytes( query_id ) );
            data = out.toByteArray();
        }
        catch ( Exception e ) {
            throw new WinnyProtocolException( e );
        }
        finally {
            try {
                out.close();
            }
            catch ( Exception e ) {
                e.printStackTrace();
            }
        }
    }

    @Override
    void rawDataUnpack()
        throws WinnyProtocolException {
        _ByteArrayInputStream in = new _ByteArrayInputStream( data );
        try {
            keyword = new String( in.read( 0xff ), "windows-31j" );
            trip = new String( in.read( 0xf ), "windows-31j" );
            query_id = ConvertUtil.littleEndianBytes2int( in.read( 4 ) );
        }
        catch ( Exception e ) {
            throw new WinnyProtocolException( e );
        }
        finally {
            try {
                in.close();
            }
            catch ( Exception e ) {
                e.printStackTrace();
            }
        }
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword( String keyword ) {
        this.keyword = keyword;
    }

    public String getTrip() {
        return trip;
    }

    public void setTrip( String trip ) {
        this.trip = trip;
    }

    public int getQuery_id() {
        return query_id;
    }

    public void setQuery_id( int query_id ) {
        this.query_id = query_id;
    }

}
