/*
 * Copyright 2007 nori090
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jimmy;

import junit.framework.TestCase;

/**
 * node test
 * 
 * @author nori090
 * @version $Rev: 17 $ $Date: 2008-03-25 22:45:24 +0900 (Tue, 25 Mar 2008) $
 */
public class NodeTest
    extends TestCase {

    public void test() {
        try {
            Node n1 = new Node( "@d9d162a23cc199f08f40b3b45704846392a6d73d" );
            Node n2 = new Node( "192.168.77.128", 6191 );
            assertEquals( "192.168.77.128", n1.address );
            assertEquals( 6191, n1.port );
            assertEquals( "@d9d162a23cc199f08f40b3b45704846392a6d73d", n1.node_string );
            
            assertEquals( "192.168.77.128", n2.address );
            assertEquals( 6191, n2.port );
            assertEquals( "@d9d162a23cc199f08f40b3b45704846392a6d73d", n2.node_string );
        }
        catch ( Exception e ) {
            e.printStackTrace();
            fail();
        }
    }
}
