/*
 * Copyright 2007 nori090
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package lib2chj.struct;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * @author nori090
 * @version $Rev:3452 $ $Date:2007-12-22 15:11:38 +0000 (土, 22 12 2007) $
 */
public class Comment {
    // 所属スレッド
    Thread thread;

    // レス番号
    int num;

    // 名前
    String name;

    // 書き込み日付
    String date;

    // 書き込み者ID
    String id;

    // mail to
    String mailto;

    // body
    String body;

    // constructor
    public Comment( Thread thread ) {
        super();
        this.thread = thread;
    }

    // getter and setter
    public Thread getThread() {
        return thread;
    }

    public int getNum() {
        return num;
    }

    public Comment setNum( int num ) {
        this.num = num;
        return this;
    }

    public String getName() {
        return name;
    }

    public Comment setName( String name ) {
        this.name = name;
        return this;
    }

    public String getDate() {
        return date;
    }

    public Comment setDate( String date ) {
        this.date = date;
        return this;
    }

    public String getId() {
        return id;
    }

    public Comment setId( String id ) {
        this.id = id;
        return this;
    }

    public String getMailto() {
        return mailto;
    }

    public Comment setMailto( String mailto ) {
        this.mailto = mailto;
        return this;
    }

    public String getBody() {
        return body;
    }

    public Comment setBody( String body ) {
        this.body = body;
        return this;
    }

    public String toString_d() {
        return new ToStringBuilder( this ).append( "thread", thread ).append( "num", num ).append( "name", name ).append(
                                                                                                                          "date",
                                                                                                                          date ).append(
                                                                                                                                         "id",
                                                                                                                                         id ).append(
                                                                                                                                                      "mailto",
                                                                                                                                                      mailto ).append(
                                                                                                                                                                       "body",
                                                                                                                                                                       body ).toString();
    }

    public String view() {    // レス番号
        return "No."+getNum()+" name:["+getName()+"] date:["+getDate()+"] id:["+getId()+"] mailto:["+getMailto()+"] \r\n"+getBody();
    }

}
