/*
 * Copyright 2007 nori090
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package lib2chj.struct;

import java.util.Map;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * @author nori090
 * @version $Rev:3452 $ $Date:2007-12-22 15:11:38 +0000 (土, 22 12 2007) $
 */
public class Ita {
    // 所属鯖
    Server serv;

    // スレッドリスト
    Map<String, Thread> threads;

    // スレッド概要リスト
    Map<String, Subject> subjects;

    // 板url
    String url;

    // 板名（英名）
    String itaName;

    // 板名（和名）
    String itaName_ja;

    // constructor
    public Ita( Server serv ) {
        this.serv = serv;
    }

    public Server getServer() {
        return serv;
    }

    public Map<String, Thread> getThreads() {
        return threads;
    }

    /** thread map の key は thread_id です。 */
    public Thread getThread( String thread_id ) {
        return threads.get( thread_id );
    }

    public Ita setThreads( Map<String, Thread> threads ) {
        this.threads = threads;
        return this;
    }

    public Ita putThread( Thread thread ) {
        this.threads.put( thread.getId(), thread );
        return this;
    }

    public Map<String, Subject> getSubjects() {
        return subjects;
    }

    /** subject map の key は thread_id です。 */
    public Subject getSubject( String thread_id ) {
        return subjects.get( thread_id );
    }

    public Ita setSubjects( Map<String, Subject> subjects ) {
        this.subjects = subjects;
        return this;
    }

    public Ita putSubject( Subject subject ) {
        this.subjects.put( subject.getId(), subject );
        return this;
    }

    public String getUrl() {
        return url;
    }

    public Ita setUrl( String url ) {
        this.url = url;
        return this;
    }

    public String getItaName() {
        return itaName;
    }

    public Ita setItaName( String itaName ) {
        this.itaName = itaName;
        return this;
    }

    public String getItaName_ja() {
        return itaName_ja;
    }

    public void setItaName_ja( String itaName_ja ) {
        this.itaName_ja = itaName_ja;
    }

    public String toString_d() {
        return new ToStringBuilder( this ).append( "threads", threads ).append( "subjects", subjects ).append( "url",
                                                                                                               url ).append(
                                                                                                                             "itaName",
                                                                                                                             itaName ).append(
                                                                                                                                               "itaName_ja",
                                                                                                                                               itaName_ja ).toString();
    }

    public String view() {
        return this.getItaName_ja();
    }
    
}
