/*
 * Copyright 2007 nori090
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package lib2chj.struct;

import java.util.Map;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 
 * @author nori090
 * @version $Rev: 19 $ $Date: 2008-03-25 22:46:11 +0900 (Tue, 25 Mar 2008) $
 */
public class Server {
    // 板リスト
    Map<String, Ita> itaMap;

    // 鯖名（ドメイン名）
    String serverName;

    public String getServerName() {
        return serverName;
    }

    public Server setServerName( String serverName ) {
        this.serverName = serverName;
        return this;
    }

    public Map<String, Ita> getItaMap() {
        return itaMap;
    }

    /** ita map の key は ita_name です。 */
    public Ita getIta( String key ) {
        return this.itaMap.get( key );
    }

    public Server setItaMap( Map<String, Ita> itaMap ) {
        this.itaMap = itaMap;
        return this;
    }

    public Server putIta( Ita ita ) {
        this.itaMap.put( ita.getItaName(), ita );
        return this;
    }

    // debug string
    public String toString_d() {
        return new ToStringBuilder( this ).append( "itaMap", itaMap ).append( "serverName", serverName ).toString();
    }
}
