using System;
using System.ComponentModel;
using System.Collections.Generic;
using System.Data;
using System.Text;
using System.Text.RegularExpressions;
using System.Drawing;
using System.Reflection;
using System.Xml;
using System.Xml.Serialization;
using System.IO;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PeerCastMultiPlayer2
{
    public class PlayerSetting
    {
        public static void Save(PlayerSetting[] favSettingList)
        {
            Serializer.Save("PlayTypes.xml", favSettingList);
        }

        public static PlayerSetting[] Load()
        {
            PlayerSetting[] obj =
                Serializer.Load("PlayTypes.xml", typeof(PlayerSetting[])) as PlayerSetting[];
            if (obj == null) return null;
            return obj;
        }

        string _type = string.Empty;

        public string Type
        {
            get { return _type; }
            set { _type = value; }
        }

        string _player = string.Empty;

        public string Player
        {
            get { return _player; }
            set { _player = value; }
        }

        string _argument = "<stream /> <channelname />";

        public string Argument
        {
            get { return _argument; }
            set { _argument = value; }
        }
    }
}
