using System.Drawing;

namespace PeerCastMultiPlayer2
{
    public struct XmlFont
    {
        private string fontFamily;
        private GraphicsUnit graphicsUnit;
        private float size;
        private FontStyle style;

        public XmlFont(Font f)
        {
            fontFamily = f.FontFamily.Name;
            graphicsUnit = f.Unit;
            size = f.Size;
            style = f.Style;
        }

        public string FontFamily
        {
            get { return fontFamily; }
            set { fontFamily = value; }
        }

        public GraphicsUnit GraphicsUnit
        {
            get { return graphicsUnit; }
            set { graphicsUnit = value; }
        }

        public float Size
        {
            get { return size; }
            set { size = value; }
        }

        public FontStyle Style
        {
            get { return style; }
            set { style = value; }
        }

        public Font ToFont()
        {
            return new Font(FontFamily, Size, Style, GraphicsUnit);
        }
    }
}
