using System;
using System.Collections.Generic;
using System.IO;
using System.Windows.Forms;
using System.Xml.Serialization;

namespace PeerCastMultiPlayer2
{
    [Serializable()]
    public class ToolSetting
    {
        public static void Save(ToolSetting[] target)
        {
            Serializer.Save("Tools.xml", target);
        }

        public static ToolSetting[] Load()
        {
            ToolSetting[] obj =
                Serializer.Load("Tools.xml", typeof(ToolSetting[])) as ToolSetting[];
            if (obj == null) return null;
            return obj;
        }

        private string name = string.Empty;

        public string Name
        {
            get { return name; }
            set { name = value; }
        }

        private string path = string.Empty;

        public string Path
        {
            get { return path; }
            set { path = value; }
        }

        private string arg = string.Empty;

        public string Arg
        {
            get { return arg; }
            set { arg = value; }
        }
    }
}