using System;
using System.Collections.Generic;
using System.Text;

namespace pcmp
{
    public class BalloonMessageManager
    {
        // ----------------------------------------------------------
        // tB[h
        // ----------------------------------------------------------
        private Queue<BalloonMessageItem> queue;

        // ----------------------------------------------------------
        // vpeB
        // ----------------------------------------------------------
        public Queue<BalloonMessageItem> Queue
        {
            get { return queue; }
            set { queue = value; }
        }

        // ----------------------------------------------------------
        // \bh
        // ----------------------------------------------------------
        /// <summary>
        /// L[Ƀ`lǉ
        /// </summary>
        /// <param name="channels">ǉChannel̃Xg</param>
        public void AddChannels(List<Channel> channels)
        {
            if (channels == null) throw new ArgumentNullException();
            BalloonMessageItem nitem;
            foreach (Channel item in channels)
            {
                nitem = new BalloonMessageItem();
                nitem.Text = item.ChannelName + "\n" + item.Detail.Substring(0, 30);
                nitem.Sound = item.Sound;
                nitem.Channel = item;
                queue.Enqueue(nitem);
            }
        }

        /// <summary>
        /// L[Ƀ`lǉ
        /// </summary>
        /// <param name="item">ǉChannel</param>
        /// <param name="title">ǉACẽ^Cg</param>
        public void AddChannel(Channel item, string title)
        {
            if (item == null) throw new ArgumentNullException();
            BalloonMessageItem nitem = new BalloonMessageItem();
            nitem.Title = title;
            string detail;
            if (item.Detail.Length > 30)
                detail = item.Detail.Substring(0, 30);
            else
                detail = item.Detail;
            nitem.Text = item.ChannelName + "(" + item.Status + ")\n@" + detail;
            nitem.Sound = item.Sound;
            nitem.Channel = item;
            queue.Enqueue(nitem);
        }

        /// <summary>
        /// RXgN^
        /// </summary>
        public BalloonMessageManager()
        {
            queue = new Queue<BalloonMessageItem>();
        }
    }

    public class BalloonMessageItem : ICloneable
    {
        // ----------------------------------------------------------
        // tB[h
        // ----------------------------------------------------------
        public string Text = string.Empty;
        public string Title = string.Empty;
        public string Sound = string.Empty;
        public Channel Channel = null;

        #region ICloneable o

        public object Clone()
        {
            return this.MemberwiseClone();
        }

        #endregion
    }
}
