using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Drawing;

namespace pcmp.Forms.Controls
{
    public class OwnerdrawListBox : ListBox
    {
        public OwnerdrawListBox()
        {
            this.DrawMode = DrawMode.OwnerDrawFixed;
        }

        protected override void OnDrawItem(DrawItemEventArgs e)
        {
            if (this.Items.Count == 0) return;
            e.Graphics.FillRectangle(new SolidBrush(this.BackColor), e.Bounds);
                            Rectangle textRect = new Rectangle(e.Bounds.X + 5, e.Bounds.Y+5, e.Bounds.Width - 5,
                        e.Bounds.Height - 5);

            if ((e.State & DrawItemState.Selected) == DrawItemState.Selected)
            {
                Color colFocus = Color.FromArgb(0x20, this.ForeColor.R,
                    this.ForeColor.G, this.ForeColor.B);

                using (Font boldFont = new Font(e.Font, FontStyle.Bold))
                using (SolidBrush bFocus = new SolidBrush(colFocus))
                using (Pen p = new Pen(this.ForeColor))
                {
                    TextRenderer.DrawText(e.Graphics, this.Items[e.Index].ToString(), boldFont, textRect,
                        this.ForeColor, this.BackColor, TextFormatFlags.EndEllipsis);
                    Rectangle boundFocus = new Rectangle(e.Bounds.X + 1, e.Bounds.Y + 1,
                                                         e.Bounds.Width - 3,
                                                         e.Bounds.Height - 2);
                    e.Graphics.FillRectangle(bFocus, boundFocus);
                    e.Graphics.DrawRectangle(p, boundFocus);
                }
            }
            else
            {
                if (e.Index != -1)
                    TextRenderer.DrawText(e.Graphics, this.Items[e.Index].ToString(), this.Font,
                        textRect, this.ForeColor, this.BackColor, TextFormatFlags.EndEllipsis);
            }

            base.OnDrawItem(e);
        }
    }
}
