using System;
using System.Windows.Forms;
using pcmp.Setting;
using WeifenLuo.WinFormsUI.Docking;

namespace pcmp.Forms
{
    public partial class FormBrowser : DockContent
    {
        public FormBrowser()
        {
            // Application.Idle += new EventHandler(Application_Idle);
            InitializeComponent();
            InitializeLinks();
            InitializeBrowser();
        }

        private void InitializeLinks()
        {
            while (toolStripButtonQuickLinks.DropDown.Items.Count > 8)
            {
                toolStripButtonQuickLinks.DropDown.Items.RemoveAt(8);
            }

            if(Settings.YpSettings != null)
            foreach (YpSetting yp in Settings.YpSettings)
            {
                ToolStripMenuItem item = new ToolStripMenuItem();
                item.Text = yp.YpName;
                item.Tag = yp.YpAddr;
                item.Click += new EventHandler(item_Click);
                toolStripButtonQuickLinks.DropDown.Items.Add(item);
            }
        }

        void item_Click(object sender, EventArgs e)
        {
            webbrowser.Navigate(((ToolStripMenuItem)sender).Tag as string);
        }

        void Application_Idle(object sender, EventArgs e)
        {
            // Application.Idle -= new EventHandler(Application_Idle);
            
        }

        private void InitializeBrowser()
        {
            webbrowser.CanGoBackChanged += new EventHandler(webbrowser_CanGoBackChanged);
            webbrowser.CanGoForwardChanged += new EventHandler(webbrowser_CanGoForwardChanged);
            webbrowser.Navigated += new WebBrowserNavigatedEventHandler(webbrowser_Navigated);
            webbrowser.DocumentTitleChanged += new EventHandler(webbrowser_DocumentTitleChanged);
        }

        void webbrowser_DocumentTitleChanged(object sender, EventArgs e)
        {
            if (webbrowser.Document.Title.Length == 0)
            {
                this.TabText = webbrowser.Document.Url.AbsoluteUri;
            }
            else this.TabText = webbrowser.Document.Title;
        }

        public void NavigateUrl(string url)
        {
            if(!string.IsNullOrEmpty(url))
                webbrowser.Navigate(url);
        }

        void webbrowser_Navigated(object sender, WebBrowserNavigatedEventArgs e)
        {
            toolStripComboBoxAddress.Text = webbrowser.Url.AbsoluteUri;
        }

        void webbrowser_CanGoForwardChanged(object sender, EventArgs e)
        {
            toolStripButtonGoForward.Enabled = webbrowser.CanGoForward;
        }

        void webbrowser_CanGoBackChanged(object sender, EventArgs e)
        {
            toolStripButtonGoback.Enabled = webbrowser.CanGoBack;
        }

        private void toolStripComboBoxAddress_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Enter)
            {
                e.SuppressKeyPress = true;
                webbrowser.Navigate(toolStripComboBoxAddress.Text);
            }
        }

        private void menuItemOpenInfo_Click(object sender, EventArgs e)
        {
            webbrowser.Navigate(string.Format("http://{0}/html/ja/index.html", Settings.GeneralSetting.NetworkSetting.HostAddr));
        }

        private void menuItemOpenRelay_Click(object sender, EventArgs e)
        {
            webbrowser.Navigate(string.Format("http://{0}/html/ja/relays.html", Settings.GeneralSetting.NetworkSetting.HostAddr));
        }

        private void menuItemOpenBroadcast_Click(object sender, EventArgs e)
        {
            webbrowser.Navigate(string.Format("http://{0}/html/ja/broadcast.html", Settings.GeneralSetting.NetworkSetting.HostAddr));
        }

        private void menuItemOpenConnection_Click(object sender, EventArgs e)
        {
            webbrowser.Navigate(string.Format("http://{0}/html/ja/connections.html", Settings.GeneralSetting.NetworkSetting.HostAddr));
        }

        private void menuItemOpenLog_Click(object sender, EventArgs e)
        {
            webbrowser.Navigate(string.Format("http://{0}/html/ja/viewlog.html", Settings.GeneralSetting.NetworkSetting.HostAddr));
        }

        private void menuItemOpenConfig_Click(object sender, EventArgs e)
        {
            webbrowser.Navigate(string.Format("http://{0}/html/ja/settings.html", Settings.GeneralSetting.NetworkSetting.HostAddr));
        }

        private void toolStripButtonGoback_Click(object sender, EventArgs e)
        {
            webbrowser.GoBack();
        }

        private void toolStripButtonGoForward_Click(object sender, EventArgs e)
        {
            webbrowser.GoForward();
        }

        private void toolStripButtonStop_Click(object sender, EventArgs e)
        {
            webbrowser.Stop();
        }

        private void toolStripButtonRefresh_Click(object sender, EventArgs e)
        {
            webbrowser.Refresh();
        }

        private void toolStripButtonQuickLinks_ButtonClick(object sender, EventArgs e)
        {
            toolStripButtonQuickLinks.DropDown.Show();
        }

        private void toolStripButtonClose_Click(object sender, EventArgs e)
        {
            this.Close();
        }
    }
}